/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.serializer.configurate4;

import java.lang.reflect.Type;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.nbt.api.BinaryTagHolder;
import net.kyori.adventure.text.event.HoverEvent;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.serialize.TypeSerializer;

final class HoverEventShowItemSerializer
implements TypeSerializer<HoverEvent.ShowItem> {
    static final HoverEventShowItemSerializer INSTANCE = new HoverEventShowItemSerializer();
    static final String ID = "id";
    static final String COUNT = "count";
    static final String TAG = "tag";

    private HoverEventShowItemSerializer() {
    }

    public HoverEvent.ShowItem deserialize(@NonNull Type type, @NonNull ConfigurationNode value) throws SerializationException {
        Key id = (Key)value.node(new Object[]{ID}).get(Key.class);
        if (id == null) {
            throw new SerializationException("An id is required to deserialize the show_item hover event");
        }
        int count = value.node(new Object[]{COUNT}).getInt(1);
        String tag = value.node(new Object[]{TAG}).getString();
        return HoverEvent.ShowItem.of((Key)id, (int)count, (BinaryTagHolder)(tag == null ? null : BinaryTagHolder.of((String)tag)));
    }

    public void serialize(@NonNull Type type, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable HoverEvent.ShowItem obj, @NonNull ConfigurationNode value) throws SerializationException {
        if (obj == null) {
            value.set(null);
            return;
        }
        value.node(new Object[]{ID}).set(Key.class, (Object)obj.item());
        value.node(new Object[]{COUNT}).set((Object)obj.count());
        if (obj.nbt() == null) {
            value.node(new Object[]{TAG}).set(null);
        } else {
            value.node(new Object[]{TAG}).set((Object)obj.nbt().string());
        }
    }
}

