/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.serializer.configurate4;

import io.leangen.geantyref.TypeToken;
import java.lang.reflect.Type;
import java.util.function.Predicate;
import net.kyori.adventure.util.Index;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.configurate.serialize.ScalarSerializer;
import org.spongepowered.configurate.serialize.SerializationException;

final class IndexSerializer<T>
extends ScalarSerializer<T> {
    private final Index<String, T> idx;

    IndexSerializer(@NonNull TypeToken<T> type, @NonNull Index<String, T> idx) {
        super(type);
        this.idx = idx;
    }

    public @NonNull T deserialize(@NonNull Type type, @NonNull Object obj) throws SerializationException {
        Object value = this.idx.value((Object)obj.toString());
        if (value == null) {
            throw new SerializationException("No value for key '" + obj + "' in index for type " + this.type());
        }
        return (T)value;
    }

    public Object serialize(@NonNull T item, @NonNull Predicate<Class<?>> typeSupported) {
        return this.idx.key(item);
    }
}

