/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.serializer.configurate4;

import java.lang.reflect.Type;
import java.util.function.Predicate;
import net.kyori.adventure.key.InvalidKeyException;
import net.kyori.adventure.key.Key;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.configurate.serialize.CoercionFailedException;
import org.spongepowered.configurate.serialize.ScalarSerializer;
import org.spongepowered.configurate.serialize.SerializationException;

final class KeySerializer
extends ScalarSerializer<Key> {
    static final KeySerializer INSTANCE = new KeySerializer();

    private KeySerializer() {
        super(Key.class);
    }

    public @NonNull Key deserialize(@NonNull Type type, @NonNull Object obj) throws SerializationException {
        if (!(obj instanceof CharSequence)) {
            throw new CoercionFailedException(obj, "string");
        }
        try {
            return Key.key((String)obj.toString());
        }
        catch (InvalidKeyException ex) {
            throw new SerializationException((Throwable)ex);
        }
    }

    public @NonNull Object serialize(@NonNull Key item, @NonNull Predicate<Class<?>> typeSupported) {
        return item.asString();
    }
}

