/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.serializer.configurate4;

import java.lang.reflect.Type;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.sound.Sound;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.serialize.TypeSerializer;

final class SoundSerializer
implements TypeSerializer<Sound> {
    static final SoundSerializer INSTANCE = new SoundSerializer();
    static final String NAME = "name";
    static final String SOURCE = "source";
    static final String PITCH = "pitch";
    static final String VOLUME = "volume";

    private SoundSerializer() {
    }

    public @Nullable Sound deserialize(@NonNull Type type, @NonNull ConfigurationNode value) throws SerializationException {
        if (value.empty()) {
            return null;
        }
        Key name = (Key)value.node(new Object[]{NAME}).get(Key.class);
        Sound.Source source = (Sound.Source)value.node(new Object[]{SOURCE}).get(Sound.Source.class);
        float volume = value.node(new Object[]{VOLUME}).getFloat(1.0f);
        float pitch = value.node(new Object[]{PITCH}).getFloat(1.0f);
        if (name == null || source == null) {
            throw new SerializationException("A name and source are required to deserialize a Sound");
        }
        return Sound.sound((Key)name, (Sound.Source)source, (float)volume, (float)pitch);
    }

    public void serialize(@NonNull Type type, @Nullable Sound obj, @NonNull ConfigurationNode value) throws SerializationException {
        if (obj == null) {
            value.set(null);
            return;
        }
        value.node(new Object[]{NAME}).set(Key.class, (Object)obj.name());
        value.node(new Object[]{SOURCE}).set(Sound.Source.class, (Object)obj.source());
        value.node(new Object[]{VOLUME}).set((Object)Float.valueOf(obj.volume()));
        value.node(new Object[]{PITCH}).set((Object)Float.valueOf(obj.pitch()));
    }
}

