/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.serializer.configurate4;

import java.lang.reflect.Type;
import java.util.Collections;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.sound.SoundStop;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.serialize.TypeSerializer;

final class SoundStopSerializer
implements TypeSerializer<SoundStop> {
    static final SoundStopSerializer INSTANCE = new SoundStopSerializer();
    static final String SOUND = "sound";
    static final String SOURCE = "source";

    private SoundStopSerializer() {
    }

    public SoundStop deserialize(@NonNull Type type, @NonNull ConfigurationNode value) throws SerializationException {
        if (value.empty()) {
            return SoundStop.all();
        }
        Key sound = (Key)value.node(new Object[]{SOUND}).get(Key.class);
        Sound.Source source = (Sound.Source)value.node(new Object[]{SOURCE}).get(Sound.Source.class);
        if (sound == null) {
            return source == null ? SoundStop.all() : SoundStop.source((Sound.Source)source);
        }
        return source == null ? SoundStop.named((Key)sound) : SoundStop.namedOnSource((Key)sound, (Sound.Source)source);
    }

    public void serialize(@NonNull Type type, @Nullable SoundStop obj, @NonNull ConfigurationNode value) throws SerializationException {
        value.node(new Object[]{SOUND}).set(Key.class, (Object)(obj == null ? null : obj.sound()));
        value.node(new Object[]{SOURCE}).set(Sound.Source.class, (Object)(obj == null ? null : obj.source()));
        if (value.empty()) {
            value.set(Collections.emptyMap());
        }
    }
}

