/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.serializer.configurate4;

import java.lang.reflect.Type;
import java.time.Duration;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.title.Title;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.serialize.TypeSerializer;

final class TitleSerializer
implements TypeSerializer<Title> {
    static final TitleSerializer INSTANCE = new TitleSerializer();
    static final Duration KEEP = Duration.ofSeconds(-1L);
    static final String TITLE = "title";
    static final String SUBTITLE = "subtitle";
    static final String TIMES = "times";
    static final String FADE_IN = "fade-in";
    static final String STAY = "stay";
    static final String FADE_OUT = "fade-out";

    private TitleSerializer() {
    }

    public @Nullable Title deserialize(@NonNull Type type, @NonNull ConfigurationNode value) throws SerializationException {
        if (value.empty()) {
            return null;
        }
        Component title = (Component)value.node(new Object[]{TITLE}).get(Component.class, (Object)Component.empty());
        Component subtitle = (Component)value.node(new Object[]{SUBTITLE}).get(Component.class, (Object)Component.empty());
        Duration fadeIn = (Duration)value.node(new Object[]{TIMES, FADE_IN}).get(Duration.class, (Object)KEEP);
        Duration stay = (Duration)value.node(new Object[]{TIMES, STAY}).get(Duration.class, (Object)KEEP);
        Duration fadeOut = (Duration)value.node(new Object[]{TIMES, FADE_OUT}).get(Duration.class, (Object)KEEP);
        if (!(Objects.equals(fadeIn, KEEP) && Objects.equals(stay, KEEP) && Objects.equals(fadeOut, KEEP))) {
            return Title.title((Component)title, (Component)subtitle, (Title.Times)Title.Times.of((Duration)fadeIn, (Duration)stay, (Duration)fadeOut));
        }
        return Title.title((Component)title, (Component)subtitle);
    }

    public void serialize(@NonNull Type type, @Nullable Title obj, @NonNull ConfigurationNode value) throws SerializationException {
        if (obj == null) {
            value.set(null);
            return;
        }
        value.node(new Object[]{TITLE}).set(Component.class, (Object)obj.title());
        value.node(new Object[]{SUBTITLE}).set(Component.class, (Object)obj.subtitle());
        // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable Title.Times times = obj.times();
        value.node(new Object[]{TIMES, FADE_IN}).set(Duration.class, times == null || times == Title.DEFAULT_TIMES ? null : times.fadeIn());
        value.node(new Object[]{TIMES, STAY}).set(Duration.class, times == null || times == Title.DEFAULT_TIMES ? null : times.stay());
        value.node(new Object[]{TIMES, FADE_OUT}).set(Duration.class, times == null || times == Title.DEFAULT_TIMES ? null : times.fadeOut());
    }
}

