/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.blossom;

import java.util.Objects;
import net.kyori.blossom.ResourceTemplateSet;
import net.kyori.blossom.SourceTemplateSet;
import net.kyori.blossom.TemplateSet;
import net.kyori.mammoth.Configurable;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.PolymorphicDomainObjectContainer;
import org.jetbrains.annotations.NotNull;

public interface BlossomExtension {
    public static final String RESOURCE_TEMPLATE_SET_NAME = "resource";
    public static final String GROOVY_SOURCES_TEMPLATE_SET_NAME = "groovy";
    public static final String JAVA_SOURCES_TEMPLATE_SET_NAME = "java";
    public static final String KOTLIN_SOURCES_TEMPLATE_SET_NAME = "kotlin";
    public static final String SCALA_SOURCES_TEMPLATE_SET_NAME = "scala";

    @NotNull
    default public NamedDomainObjectProvider<ResourceTemplateSet> resources() {
        return this.customResources(RESOURCE_TEMPLATE_SET_NAME);
    }

    default public void resources(@NotNull Action<? super ResourceTemplateSet> configureAction) {
        this.resources().configure(Objects.requireNonNull(configureAction, "configureAction"));
    }

    @NotNull
    default public NamedDomainObjectProvider<ResourceTemplateSet> customResources(@NotNull String setName) {
        Objects.requireNonNull(setName, "setName");
        if (this.getTemplateSets().getNames().contains(setName)) {
            return this.getTemplateSets().named(setName, ResourceTemplateSet.class);
        }
        return this.getTemplateSets().register(setName, ResourceTemplateSet.class);
    }

    default public void customResources(@NotNull String setName, @NotNull Action<? super ResourceTemplateSet> configureAction) {
        this.customResources(setName).configure(Objects.requireNonNull(configureAction, "configureAction"));
    }

    private NamedDomainObjectProvider<SourceTemplateSet> registerSourceTemplateSet(String name, Action<SourceTemplateSet> setLanguageChooser) {
        if (this.getTemplateSets().getNames().contains(name)) {
            return this.getTemplateSets().named(name, SourceTemplateSet.class);
        }
        return this.getTemplateSets().register(name, SourceTemplateSet.class, setLanguageChooser);
    }

    @NotNull
    default public NamedDomainObjectProvider<SourceTemplateSet> groovySources() {
        return this.registerSourceTemplateSet(GROOVY_SOURCES_TEMPLATE_SET_NAME, (Action<SourceTemplateSet>)((Action)SourceTemplateSet::groovy));
    }

    default public void groovySources(@NotNull Action<? super SourceTemplateSet> configureAction) {
        this.registerSourceTemplateSet(GROOVY_SOURCES_TEMPLATE_SET_NAME, (Action<SourceTemplateSet>)((Action)SourceTemplateSet::groovy)).configure(Objects.requireNonNull(configureAction, "configureAction"));
    }

    @NotNull
    default public NamedDomainObjectProvider<SourceTemplateSet> javaSources() {
        return this.registerSourceTemplateSet(JAVA_SOURCES_TEMPLATE_SET_NAME, (Action<SourceTemplateSet>)((Action)SourceTemplateSet::java));
    }

    default public void javaSources(@NotNull Action<? super SourceTemplateSet> configureAction) {
        this.registerSourceTemplateSet(JAVA_SOURCES_TEMPLATE_SET_NAME, (Action<SourceTemplateSet>)((Action)SourceTemplateSet::java)).configure(Objects.requireNonNull(configureAction, "configureAction"));
    }

    @NotNull
    default public NamedDomainObjectProvider<SourceTemplateSet> kotlinSources() {
        return this.registerSourceTemplateSet(KOTLIN_SOURCES_TEMPLATE_SET_NAME, (Action<SourceTemplateSet>)((Action)SourceTemplateSet::kotlin));
    }

    default public void kotlinSources(@NotNull Action<? super SourceTemplateSet> configureAction) {
        this.registerSourceTemplateSet(KOTLIN_SOURCES_TEMPLATE_SET_NAME, (Action<SourceTemplateSet>)((Action)SourceTemplateSet::kotlin)).configure(Objects.requireNonNull(configureAction, "configureAction"));
    }

    @NotNull
    default public NamedDomainObjectProvider<SourceTemplateSet> scalaSources() {
        return this.registerSourceTemplateSet(SCALA_SOURCES_TEMPLATE_SET_NAME, (Action<SourceTemplateSet>)((Action)SourceTemplateSet::scala));
    }

    default public void scalaSources(@NotNull Action<? super SourceTemplateSet> configureAction) {
        this.registerSourceTemplateSet(SCALA_SOURCES_TEMPLATE_SET_NAME, (Action<SourceTemplateSet>)((Action)SourceTemplateSet::scala)).configure(Objects.requireNonNull(configureAction, "configureAction"));
    }

    @NotNull
    default public NamedDomainObjectProvider<SourceTemplateSet> customSources(@NotNull String setName, @NotNull Action<? super SourceTemplateSet> configureAction) {
        Objects.requireNonNull(setName, "setName");
        NamedDomainObjectProvider setProvider = this.getTemplateSets().getNames().contains(setName) ? this.getTemplateSets().named(setName, SourceTemplateSet.class) : this.getTemplateSets().register(setName, SourceTemplateSet.class);
        setProvider.configure(Objects.requireNonNull(configureAction, "configureAction"));
        return setProvider;
    }

    @NotNull
    public PolymorphicDomainObjectContainer<TemplateSet> getTemplateSets();

    default public void templateSets(@NotNull Action<PolymorphicDomainObjectContainer<TemplateSet>> configurer) {
        Configurable.configure(this.getTemplateSets(), configurer);
    }
}

