/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.blossom;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.kyori.blossom.TemplateSet;
import net.kyori.blossom.Variant;
import net.kyori.blossom.internal.FileUtils;
import net.kyori.blossom.internal.worker.GenerateWorker;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;

public abstract class GenerateTemplates
extends DefaultTask {
    @Nested
    @NotNull
    public abstract Property<TemplateSet> getBaseSet();

    @InputFiles
    @NotNull
    protected abstract ConfigurableFileCollection getIncludesDirectories();

    @InputFiles
    @SkipWhenEmpty
    @NotNull
    protected abstract ConfigurableFileCollection getSourceDirectories();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getOutputDir();

    @Classpath
    public abstract ConfigurableFileCollection getPebbleClasspath();

    public GenerateTemplates() {
        this.getIncludesDirectories().from(new Object[]{this.getBaseSet().map(set -> set.getIncludes().getSourceDirectories())});
        this.getSourceDirectories().from(new Object[]{this.getBaseSet().map(set -> set.getTemplates().getSourceDirectories())});
    }

    @Inject
    protected abstract WorkerExecutor getWorkerExecutor();

    @TaskAction
    void generate() throws IOException {
        Path outputPath = ((Directory)this.getOutputDir().get()).getAsFile().toPath();
        if (Files.exists(outputPath, new LinkOption[0])) {
            FileUtils.deleteContents(outputPath);
        } else {
            FileUtils.createDirectoriesSymlinkSafe(outputPath);
        }
        this.getWorkerExecutor().classLoaderIsolation(spec -> spec.getClasspath().from(new Object[]{this.getPebbleClasspath()})).submit(GenerateWorker.class, spec -> {
            spec.getSetName().set(this.getBaseSet().map(TemplateSet::getName));
            spec.getGlobalParameters().set(this.getBaseSet().flatMap(TemplateSet::getProperties));
            spec.getGlobalParameterFiles().from(new Object[]{this.getBaseSet().map(TemplateSet::getPropertyFiles)});
            spec.getVariantParameters().set(this.getBaseSet().map(set -> set.getVariants().getAsMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, ent -> (Map)((Variant)ent.getValue()).getProperties().getOrElse(Map.of())))));
            spec.getVariantFiles().set(this.getBaseSet().map(set -> set.getVariants().getAsMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, ent -> ((Variant)ent.getValue()).getPropertyFiles()))));
            spec.getHeader().set(this.getBaseSet().flatMap(TemplateSet::getHeader));
            spec.getSourceDirectories().from(new Object[]{this.getSourceDirectories()});
            spec.getIncludesDirectories().from(new Object[]{this.getIncludesDirectories()});
            spec.getDestinationDirectory().set((Provider)this.getOutputDir());
        });
    }
}

