/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.blossom;

import net.kyori.blossom.Variant;
import net.kyori.mammoth.Configurable;
import org.gradle.api.Action;
import org.gradle.api.Named;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.NamedDomainObjectSet;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.NonExtendable
public interface TemplateSet
extends Named {
    @Internal
    @NotNull
    public String getName();

    @InputFiles
    @NotNull
    public ConfigurableFileCollection getPropertyFiles();

    default public void propertyFile(@NotNull Object dataFile) {
        this.getPropertyFiles().from(new Object[]{dataFile});
    }

    @Input
    @NotNull
    public MapProperty<String, Object> getProperties();

    default public void property(String property, String value) {
        this.getProperties().put((Object)property, (Object)value);
    }

    default public void property(String property, Provider<String> value) {
        this.getProperties().put((Object)property, value);
    }

    @Input
    @Optional
    @NotNull
    public Property<String> getHeader();

    @Nested
    @NotNull
    public NamedDomainObjectContainer<Variant> getVariants();

    default public void variants(String ... variants) {
        for (String variant : variants) {
            this.getVariants().register(variant);
        }
    }

    default public void variants(@NotNull Action<NamedDomainObjectSet<Variant>> configureAction) {
        Configurable.configure(this.getVariants(), configureAction);
    }

    @Internal
    @NotNull
    public SourceDirectorySet getTemplates();

    default public void templates(Object ... templates) {
        this.getTemplates().srcDirs(templates);
    }

    @Internal
    @NotNull
    public SourceDirectorySet getIncludes();

    default public void include(Object ... includes) {
        this.getIncludes().srcDirs(includes);
    }
}

