/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.blossom.internal;

import org.gradle.api.Project;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.plugins.ide.eclipse.EclipsePlugin;
import org.gradle.plugins.ide.eclipse.model.EclipseModel;
import org.gradle.plugins.ide.idea.model.IdeaModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.gradle.ext.IdeaExtPlugin;
import org.jetbrains.gradle.ext.ProjectSettings;

public final class IdeConfigurer {
    private static final String IDEA_PLUGIN = "org.jetbrains.gradle.plugin.idea-ext";

    private IdeConfigurer() {
    }

    public static boolean isIdeaImport() {
        return Boolean.getBoolean("idea.active");
    }

    public static boolean isEclipseImport() {
        return System.getProperty("eclipse.application") != null;
    }

    public static void apply(@NotNull Project project, @NotNull IdeImportAction toPerform) {
        project.getPlugins().withId(IDEA_PLUGIN, plugin -> {
            if (!IdeConfigurer.isIdeaImport()) {
                return;
            }
            IdeConfigurer.applyIdea(project, toPerform);
        });
        project.getPlugins().withType(EclipsePlugin.class, plugin -> {
            EclipseModel model = (EclipseModel)project.getExtensions().findByType(EclipseModel.class);
            if (model == null) {
                return;
            }
            toPerform.eclipse(project, model);
        });
    }

    private static void applyIdea(Project project, IdeImportAction toPerform) {
        IdeaModel model;
        Project rootProject = project.getRootProject();
        if (project != rootProject) {
            rootProject.getPlugins().apply(IdeaExtPlugin.class);
        }
        if ((model = (IdeaModel)rootProject.getExtensions().findByType(IdeaModel.class)) == null || model.getProject() == null) {
            return;
        }
        ProjectSettings ideaExt = (ProjectSettings)((ExtensionAware)model.getProject()).getExtensions().getByType(ProjectSettings.class);
        toPerform.idea(project, model, ideaExt);
    }

    public static interface IdeImportAction {
        public void idea(@NotNull Project var1, @NotNull IdeaModel var2, @NotNull ProjectSettings var3);

        public void eclipse(@NotNull Project var1, @NotNull EclipseModel var2);
    }
}

