/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.blossom.internal;

import java.util.function.Function;
import javax.inject.Inject;
import net.kyori.blossom.GenerateTemplates;
import net.kyori.blossom.SourceTemplateSet;
import net.kyori.blossom.internal.TemplateSetImpl;
import org.gradle.api.GradleException;
import org.gradle.api.file.Directory;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

public abstract class SourceTemplateSetImpl
extends TemplateSetImpl
implements SourceTemplateSet {
    private transient SourceSet pendingDestination;
    private transient TaskProvider<GenerateTemplates> pendingGenerateTask;

    @Inject
    public SourceTemplateSetImpl(String name) {
        super(name);
    }

    @Override
    public Directory resolveOutputRoot(Directory generatedDir) {
        return generatedDir.dir("sources");
    }

    @Override
    public void registerOutputWithSet(SourceSet destination, TaskProvider<GenerateTemplates> generateTask) {
        this.pendingDestination = destination;
        this.pendingGenerateTask = generateTask;
    }

    private void applySourceLens(Function<SourceSet, SourceDirectorySet> lens) {
        if (this.pendingDestination == null || this.pendingGenerateTask == null) {
            throw new GradleException("Tried to set a language before this template set has been claimed by the Blossom coordinator (or tried to set a second language!)!");
        }
        lens.apply(this.pendingDestination).srcDir((Object)this.pendingGenerateTask.map(GenerateTemplates::getOutputDir));
        this.pendingDestination = null;
        this.pendingGenerateTask = null;
    }

    private static Function<SourceSet, SourceDirectorySet> lensForNamedExtension(String extensionName) {
        return set -> {
            Object extension = set.getExtensions().getByName(extensionName);
            if (!(extension instanceof SourceDirectorySet)) {
                throw new GradleException("The extension '" + extensionName + "' on source set '" + set.getName() + " was supposed to be a SourceDirectorySet, but instead it was a " + extension.getClass().getName());
            }
            return (SourceDirectorySet)extension;
        };
    }

    @Override
    public void java() {
        this.applySourceLens(SourceSet::getJava);
    }

    @Override
    public void namedLanguageExtension(@NotNull String name) {
        this.applySourceLens(SourceTemplateSetImpl.lensForNamedExtension(name));
    }
}

