/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.blossom.internal;

import javax.inject.Inject;
import net.kyori.blossom.Variant;
import net.kyori.blossom.internal.TemplateSetInternal;
import net.kyori.blossom.internal.VariantImpl;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.jetbrains.annotations.NotNull;

public abstract class TemplateSetImpl
implements TemplateSetInternal {
    private final ConfigurableFileCollection dataFiles;
    private final MapProperty<String, Object> properties;
    private final NamedDomainObjectContainer<Variant> variants;
    private final Property<String> header;
    private final transient SourceDirectorySet includes;
    private final transient SourceDirectorySet templates;
    private final String name;

    @Inject
    public TemplateSetImpl(String name) {
        this.name = name;
        this.dataFiles = this.getObjects().fileCollection();
        this.properties = this.getObjects().mapProperty(String.class, Object.class);
        this.variants = this.getObjects().domainObjectContainer(Variant.class, n -> (Variant)this.getObjects().newInstance(VariantImpl.class, new Object[]{n}));
        this.header = this.getObjects().property(String.class);
        this.includes = this.getObjects().sourceDirectorySet(name + "-template-includes", name + " template includes");
        this.templates = this.getObjects().sourceDirectorySet(name + "-templates", name + " templates");
    }

    @Inject
    protected abstract ObjectFactory getObjects();

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public ConfigurableFileCollection getPropertyFiles() {
        return this.dataFiles;
    }

    @Override
    @NotNull
    public MapProperty<String, Object> getProperties() {
        return this.properties;
    }

    @Override
    @NotNull
    public Property<String> getHeader() {
        return this.header;
    }

    @Override
    @NotNull
    public SourceDirectorySet getIncludes() {
        return this.includes;
    }

    @Override
    @NotNull
    public SourceDirectorySet getTemplates() {
        return this.templates;
    }

    @Override
    @NotNull
    public NamedDomainObjectContainer<Variant> getVariants() {
        return this.variants;
    }
}

