/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.blossom.internal.worker;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.kyori.blossom.internal.worker.GenerateWorkerInvoker;
import net.kyori.blossom.internal.worker.TemplateParams;
import org.gradle.api.GradleException;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;

public abstract class GenerateWorker
implements WorkAction<Params> {
    @Inject
    public GenerateWorker() {
    }

    public void execute() {
        GenerateWorkerInvoker invoker;
        try {
            invoker = (GenerateWorkerInvoker)Class.forName("net.kyori.blossom.internal.worker.GenerateWorkerInvokerImpl").getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            throw new GradleException("Failed to access Blossom worker stub: " + ex.getMessage(), (Throwable)ex);
        }
        Params params = (Params)this.getParameters();
        TemplateParams globalParams = new TemplateParams((String)params.getSetName().get(), GenerateWorker.toPaths((FileCollection)params.getGlobalParameterFiles()), (Map)params.getGlobalParameters().getOrElse(Map.of()));
        Set<TemplateParams> variantParams = this.toVariantParameters((Map)params.getVariantFiles().get(), (Map)params.getVariantParameters().get());
        try {
            invoker.generate(globalParams, variantParams, GenerateWorker.toPaths((FileCollection)params.getIncludesDirectories()), GenerateWorker.toPaths((FileCollection)params.getSourceDirectories()), ((Directory)params.getDestinationDirectory().get()).getAsFile().toPath(), (String)params.getHeader().getOrNull());
        }
        catch (IOException ex) {
            throw new GradleException("Failed to process templates:" + ex.getMessage(), (Throwable)ex);
        }
    }

    private Set<TemplateParams> toVariantParameters(Map<String, ? extends FileCollection> variantFiles, Map<String, Map<String, Object>> variantProperties) {
        HashSet<TemplateParams> ret = new HashSet<TemplateParams>(variantFiles.size());
        for (String variantName : variantFiles.keySet()) {
            ret.add(new TemplateParams(variantName, GenerateWorker.toPaths(variantFiles.get(variantName)), variantProperties.getOrDefault(variantName, Map.of())));
        }
        return ret;
    }

    private static Set<Path> toPaths(FileCollection files) {
        return files.getFiles().stream().map(File::toPath).collect(Collectors.toUnmodifiableSet());
    }

    public static interface Params
    extends WorkParameters {
        public Property<String> getSetName();

        public MapProperty<String, Object> getGlobalParameters();

        public ConfigurableFileCollection getGlobalParameterFiles();

        public MapProperty<String, Map<String, Object>> getVariantParameters();

        public MapProperty<String, FileCollection> getVariantFiles();

        public Property<String> getHeader();

        public ConfigurableFileCollection getSourceDirectories();

        public ConfigurableFileCollection getIncludesDirectories();

        public DirectoryProperty getDestinationDirectory();
    }
}

