/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.blossom.internal.worker;

import io.pebbletemplates.pebble.PebbleEngine;
import io.pebbletemplates.pebble.loader.Loader;
import io.pebbletemplates.pebble.template.PebbleTemplate;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.kyori.blossom.internal.worker.GenerateWorkerInvoker;
import net.kyori.blossom.internal.worker.MultiDirectoryLoader;
import net.kyori.blossom.internal.worker.PropertyFileIO;
import net.kyori.blossom.internal.worker.TemplateParams;
import org.gradle.api.GradleException;
import org.gradle.api.InvalidUserDataException;
import org.jetbrains.annotations.Nullable;

public class GenerateWorkerInvokerImpl
implements GenerateWorkerInvoker {
    private static final String FILE_NAME_CACHE_DISAMBIGUATOR = "###";
    private static final String PEBBLE_EXTENSION = ".peb";

    @Override
    public void generate(TemplateParams globalParams, Set<TemplateParams> variantParams, Set<Path> includePaths, Set<Path> sourcePaths, Path outputDirectory, @Nullable String header) throws IOException {
        Loader<?> loader = this.makeLoader(sourcePaths, includePaths);
        PebbleEngine engine = new PebbleEngine.Builder().autoEscaping(false).defaultLocale(Locale.ROOT).loader(loader).strictVariables(true).build();
        Set<Map<String, Object>> variants = PropertyFileIO.prepareDataForGeneration(globalParams, variantParams);
        Set<String> availableTemplates = this.collectTemplateNames(sourcePaths);
        HashSet<String> seenOutputs = new HashSet<String>();
        for (String relativePath : availableTemplates) {
            PebbleTemplate fileNameTemplate = engine.getLiteralTemplate(FILE_NAME_CACHE_DISAMBIGUATOR + relativePath);
            PebbleTemplate template = engine.getTemplate(relativePath);
            for (Map<String, Object> variant : variants) {
                String outputFile = this.evaluateToString(fileNameTemplate, variant).substring(FILE_NAME_CACHE_DISAMBIGUATOR.length());
                if (outputFile.endsWith(PEBBLE_EXTENSION)) {
                    outputFile = outputFile.substring(0, outputFile.length() - PEBBLE_EXTENSION.length());
                }
                if (!seenOutputs.add(outputFile)) {
                    throw new InvalidUserDataException("Output file " + outputFile + " (a variant of input " + relativePath + ") has already been written in another variant!");
                }
                Path output = outputDirectory.resolve(outputFile);
                Files.createDirectories(output.getParent(), new FileAttribute[0]);
                BufferedWriter writer = Files.newBufferedWriter(output, StandardCharsets.UTF_8, new OpenOption[0]);
                try {
                    if (header != null) {
                        writer.write(header);
                        if (!header.endsWith("\n")) {
                            writer.newLine();
                        }
                    }
                    template.evaluate((Writer)writer, variant);
                }
                finally {
                    if (writer == null) continue;
                    writer.close();
                }
            }
        }
    }

    private Loader<?> makeLoader(Set<Path> sourcePaths, Set<Path> includePaths) {
        return new MultiDirectoryLoader(Stream.concat(sourcePaths.stream(), includePaths.stream()).collect(Collectors.toList()), StandardCharsets.UTF_8);
    }

    private Set<String> collectTemplateNames(Set<Path> sourceDirs) {
        final HashSet templateNames = new HashSet();
        for (final Path sourcePath : sourceDirs) {
            try {
                Files.walkFileTree(sourcePath, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFileFailed(Path file, IOException exc) {
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                        templateNames.add(sourcePath.relativize(file).toString());
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException ex) {
                throw new GradleException("Exception encountered when gathering template names in source directory '" + sourcePath + "'", (Throwable)ex);
            }
        }
        return Set.copyOf(templateNames);
    }

    private String evaluateToString(PebbleTemplate template, Map<String, Object> data) throws IOException {
        StringWriter writer = new StringWriter();
        template.evaluate((Writer)writer, data);
        return writer.toString();
    }
}

