/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.blossom;

import java.io.File;
import java.util.Collection;
import net.kyori.blossom.BlossomExtension;
import net.kyori.blossom.GenerateTemplates;
import net.kyori.blossom.internal.BlossomExtensionImpl;
import net.kyori.blossom.internal.IdeConfigurer;
import net.kyori.blossom.internal.TemplateSetInternal;
import net.kyori.mammoth.ProjectPlugin;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.file.Directory;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.plugins.ide.eclipse.model.EclipseModel;
import org.gradle.plugins.ide.idea.model.IdeaModel;
import org.gradle.util.GradleVersion;
import org.jetbrains.gradle.ext.ProjectSettings;
import org.jetbrains.gradle.ext.TaskTriggersConfig;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class Blossom
implements ProjectPlugin {
    private static final String GENERATION_GROUP = "blossom";
    private static final String EXTENSION_NAME = "blossom";
    private static final String BLOSSOM_RUNTIME_CONFIG = "blossomRuntime";
    private static final String PEBBLE_ARTIFACT_ID = "io.pebbletemplates:pebble";
    private static final String SNAKEYAML_ARTIFACT_ID = "org.snakeyaml:snakeyaml-engine";

    public void apply(Project project, PluginContainer plugins, ExtensionContainer extensions, TaskContainer tasks) {
        plugins.withType(JavaBasePlugin.class, $ -> {
            SetProperty outputDirs = project.getObjects().setProperty(File.class);
            this.registerGenerateAllTask(project, tasks, (SetProperty<File>)outputDirs);
            SourceSetContainer sourceSets = (SourceSetContainer)extensions.getByType(SourceSetContainer.class);
            NamedDomainObjectProvider<Configuration> blossomRuntimeConfig = this.registerBlossomRuntimeConfig(project.getDependencies(), project.getConfigurations());
            sourceSets.all(set -> {
                BlossomExtension extension = (BlossomExtension)set.getExtensions().create(BlossomExtension.class, "blossom", BlossomExtensionImpl.class, new Object[]{project.getObjects()});
                Directory baseInputDir = project.getLayout().getProjectDirectory().dir("src/" + set.getName());
                Provider generatedBase = project.getLayout().getBuildDirectory().dir("generated");
                extension.getTemplateSets().all(templateSet -> {
                    TemplateSetInternal internal = (TemplateSetInternal)templateSet;
                    Provider templateSetOutput = generatedBase.map(internal::resolveOutputRoot).map(dir -> dir.dir("blossom/" + set.getName() + "/" + templateSet.getName()));
                    internal.templates(baseInputDir.dir(templateSet.getName() + "-templates"));
                    internal.getTemplates().getDestinationDirectory().set(templateSetOutput);
                    TaskProvider generateTask = tasks.register(set.getTaskName("generate", templateSet.getName() + "Templates"), GenerateTemplates.class, task -> {
                        task.setGroup("blossom");
                        task.getBaseSet().set(templateSet);
                        task.getPebbleClasspath().from(new Object[]{blossomRuntimeConfig.map(it -> it.getIncoming().getFiles())});
                    });
                    outputDirs.add(internal.getTemplates().getDestinationDirectory().map(Directory::getAsFile));
                    internal.getTemplates().compiledBy(generateTask, GenerateTemplates::getOutputDir);
                    internal.registerOutputWithSet((SourceSet)set, (TaskProvider<GenerateTemplates>)generateTask);
                });
            });
        });
    }

    private NamedDomainObjectProvider<Configuration> registerBlossomRuntimeConfig(DependencyHandler dependencies, ConfigurationContainer configurations) {
        return configurations.register(BLOSSOM_RUNTIME_CONFIG, config -> {
            config.setDescription("Dependencies used to perform template processing with Blossom. Currently includes Pebble and SnakeYAML Engine");
            config.setVisible(false);
            config.setCanBeConsumed(false);
            config.defaultDependencies(deps -> {
                deps.add((Object)dependencies.create((Object)"org.snakeyaml:snakeyaml-engine:2.10"));
                deps.add((Object)dependencies.create((Object)"io.pebbletemplates:pebble:3.2.4"));
            });
        });
    }

    private void registerGenerateAllTask(Project project, TaskContainer tasks, final SetProperty<File> outputDirs) {
        final TaskProvider generateTemplates = tasks.register("generateTemplates", task -> task.dependsOn(new Object[]{tasks.withType(GenerateTemplates.class)}));
        IdeConfigurer.apply(project, new IdeConfigurer.IdeImportAction(){

            @Override
            public void idea(Project project, IdeaModel idea, ProjectSettings ideaExtension) {
                ((TaskTriggersConfig)((ExtensionAware)ideaExtension).getExtensions().getByType(TaskTriggersConfig.class)).afterSync(new Object[]{generateTemplates});
                project.afterEvaluate(p -> {
                    IdeaModel projectIdea = (IdeaModel)p.getExtensions().getByType(IdeaModel.class);
                    if (projectIdea.getModule() != null) {
                        projectIdea.getModule().getGeneratedSourceDirs().addAll((Collection)outputDirs.get());
                    }
                });
            }

            @Override
            public void eclipse(Project project, EclipseModel eclipse) {
                eclipse.synchronizationTasks(new Object[]{generateTemplates});
            }
        });
    }

    public @Nullable GradleVersion minimumGradleVersion() {
        return GradleVersion.version((String)"7.2");
    }
}

