/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.blossom;

import net.kyori.blossom.Variant;
import net.kyori.mammoth.Configurable;
import org.gradle.api.Action;
import org.gradle.api.Named;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.NamedDomainObjectSet;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.NullMarked;

@NullMarked
@ApiStatus.NonExtendable
public interface TemplateSet
extends Named {
    @Internal
    public String getName();

    @Input
    public Property<Boolean> getTrimNewlines();

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public ConfigurableFileCollection getPropertyFiles();

    default public void propertyFile(Object dataFile) {
        this.getPropertyFiles().from(new Object[]{dataFile});
    }

    @Input
    public MapProperty<String, Object> getProperties();

    default public void property(String property, String value) {
        this.getProperties().put((Object)property, (Object)value);
    }

    default public void property(String property, Provider<String> value) {
        this.getProperties().put((Object)property, value);
    }

    @Input
    @Optional
    public Property<String> getHeader();

    @Nested
    public NamedDomainObjectContainer<Variant> getVariants();

    default public void variants(String ... variants) {
        for (String variant : variants) {
            this.getVariants().register(variant);
        }
    }

    default public void variants(Action<NamedDomainObjectSet<Variant>> configureAction) {
        Configurable.configure(this.getVariants(), configureAction);
    }

    @Internal
    public SourceDirectorySet getTemplates();

    default public void templates(Object ... templates) {
        this.getTemplates().srcDirs(templates);
    }

    @Internal
    public SourceDirectorySet getIncludes();

    default public void include(Object ... includes) {
        this.getIncludes().srcDirs(includes);
    }
}

