/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.blossom.internal;

import org.gradle.api.Project;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.plugins.ide.eclipse.EclipsePlugin;
import org.gradle.plugins.ide.eclipse.model.EclipseModel;
import org.gradle.plugins.ide.idea.model.IdeaModel;
import org.jetbrains.gradle.ext.IdeaExtPlugin;
import org.jetbrains.gradle.ext.ProjectSettings;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class IdeConfigurer {
    private static final String IDEA_PLUGIN = "org.jetbrains.gradle.plugin.idea-ext";

    private IdeConfigurer() {
    }

    public static boolean isIdeaImport() {
        return Boolean.getBoolean("idea.active");
    }

    public static boolean isEclipseImport() {
        return System.getProperty("eclipse.application") != null;
    }

    public static void apply(Project project, IdeImportAction toPerform) {
        project.getPlugins().withId(IDEA_PLUGIN, plugin -> {
            if (!IdeConfigurer.isIdeaImport()) {
                return;
            }
            IdeConfigurer.applyIdea(project, toPerform);
        });
        project.getPlugins().withType(EclipsePlugin.class, plugin -> {
            EclipseModel model = (EclipseModel)project.getExtensions().findByType(EclipseModel.class);
            if (model == null) {
                return;
            }
            toPerform.eclipse(project, model);
        });
    }

    private static void applyIdea(Project project, IdeImportAction toPerform) {
        IdeaModel model;
        Project rootProject = project.getRootProject();
        if (project != rootProject) {
            rootProject.getPlugins().apply(IdeaExtPlugin.class);
        }
        if ((model = (IdeaModel)rootProject.getExtensions().findByType(IdeaModel.class)) == null || model.getProject() == null) {
            return;
        }
        ProjectSettings ideaExt = (ProjectSettings)((ExtensionAware)model.getProject()).getExtensions().getByType(ProjectSettings.class);
        toPerform.idea(project, model, ideaExt);
    }

    public static interface IdeImportAction {
        public void idea(Project var1, IdeaModel var2, ProjectSettings var3);

        public void eclipse(Project var1, EclipseModel var2);
    }
}

