/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.blossom.internal;

import javax.inject.Inject;
import net.kyori.blossom.Variant;
import net.kyori.blossom.internal.TemplateSetInternal;
import net.kyori.blossom.internal.VariantImpl;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.jspecify.annotations.NullMarked;

@NullMarked
public abstract class TemplateSetImpl
implements TemplateSetInternal {
    private final ConfigurableFileCollection dataFiles;
    private final MapProperty<String, Object> properties;
    private final NamedDomainObjectContainer<Variant> variants;
    private final Property<String> header;
    private final Property<Boolean> trimNewlines;
    private final transient SourceDirectorySet includes;
    private final transient SourceDirectorySet templates;
    private final String name;

    @Inject
    public TemplateSetImpl(ObjectFactory objects, String name) {
        this.name = name;
        this.dataFiles = objects.fileCollection();
        this.properties = objects.mapProperty(String.class, Object.class);
        this.variants = objects.domainObjectContainer(Variant.class, n -> (Variant)objects.newInstance(VariantImpl.class, new Object[]{n}));
        this.header = objects.property(String.class);
        this.trimNewlines = objects.property(Boolean.class).convention((Object)true);
        this.includes = objects.sourceDirectorySet(name + "-template-includes", name + " template includes");
        this.templates = objects.sourceDirectorySet(name + "-templates", name + " templates");
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ConfigurableFileCollection getPropertyFiles() {
        return this.dataFiles;
    }

    @Override
    public MapProperty<String, Object> getProperties() {
        return this.properties;
    }

    @Override
    public Property<String> getHeader() {
        return this.header;
    }

    @Override
    public Property<Boolean> getTrimNewlines() {
        return this.trimNewlines;
    }

    @Override
    public SourceDirectorySet getIncludes() {
        return this.includes;
    }

    @Override
    public SourceDirectorySet getTemplates() {
        return this.templates;
    }

    @Override
    public NamedDomainObjectContainer<Variant> getVariants() {
        return this.variants;
    }
}

