/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.blossom.internal.worker;

import io.pebbletemplates.pebble.error.LoaderException;
import io.pebbletemplates.pebble.loader.Loader;
import io.pebbletemplates.pebble.utils.PathUtils;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
final class MultiDirectoryLoader
implements Loader<String> {
    private final List<Path> directories;
    private final Charset charset;

    MultiDirectoryLoader(List<Path> directories, Charset charset) {
        this.directories = List.copyOf(directories);
        this.charset = charset;
    }

    public Reader getReader(String templateName) {
        Path file = this.findFile(templateName);
        if (file != null) {
            try {
                return Files.newBufferedReader(file, this.charset);
            }
            catch (IOException ex) {
                throw new LoaderException((Throwable)ex, "Could not load template \"" + templateName + "\" from file \"" + String.valueOf(file) + "\"");
            }
        }
        throw new LoaderException(null, "Could not find template \"" + templateName + "\" in any of: " + this.directories.stream().map(Path::toString).collect(Collectors.joining("; ")));
    }

    private @Nullable Path findFile(String templateName) {
        for (Path path : this.directories) {
            Path file = MultiDirectoryLoader.findFileIn(templateName, path);
            if (file == null && !templateName.endsWith(".peb")) {
                file = MultiDirectoryLoader.findFileIn(templateName + ".peb", path);
            }
            if (file == null) continue;
            return file;
        }
        return null;
    }

    private static @Nullable Path findFileIn(String templateName, Path path) {
        Path file = path.resolve(templateName);
        if (Files.isRegularFile(file, new LinkOption[0]) && file.toAbsolutePath().startsWith(path.toAbsolutePath())) {
            return file;
        }
        return null;
    }

    public void setSuffix(String suffix) {
        throw new UnsupportedOperationException("Not used by Blossom");
    }

    public void setPrefix(String prefix) {
        throw new UnsupportedOperationException("Not used by Blossom");
    }

    public void setCharset(String charset) {
        throw new UnsupportedOperationException("Not used by Blossom");
    }

    public String resolveRelativePath(String relativePath, String anchorPath) {
        return PathUtils.resolveRelativePath((String)relativePath, (String)anchorPath, (char)File.separatorChar);
    }

    public String createCacheKey(String templateName) {
        return templateName;
    }

    public boolean resourceExists(String templateName) {
        Path path = this.findFile(templateName);
        return path != null && Files.isRegularFile(path, new LinkOption[0]);
    }
}

