/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.blossom.internal.worker;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.kyori.blossom.internal.worker.TemplateParams;
import org.gradle.api.GradleException;
import org.gradle.api.InvalidUserDataException;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;
import org.snakeyaml.engine.v2.api.Load;
import org.snakeyaml.engine.v2.api.LoadSettings;
import org.snakeyaml.engine.v2.exceptions.YamlEngineException;

@NullMarked
final class PropertyFileIO {
    private PropertyFileIO() {
    }

    public static Set<Map<String, Object>> prepareDataForGeneration(TemplateParams globalParams, Set<TemplateParams> variantParams) {
        Map<String, Map<String, Object>> configData = PropertyFileIO.loadConfig(globalParams.name(), globalParams.files(), !variantParams.isEmpty());
        if (variantParams.isEmpty()) {
            Map<String, Object> result = configData.get(null);
            if (result == null) {
                return Set.of(globalParams.data());
            }
            result.putAll(globalParams.data());
            return Collections.singleton(result);
        }
        Map<String, Object> global = configData.remove(null);
        if (global == null) {
            global = globalParams.data();
        } else {
            global.putAll(globalParams.data());
        }
        HashSet<Map<String, Object>> output = new HashSet<Map<String, Object>>();
        for (TemplateParams variant : variantParams) {
            Map<String, Object> variantFromFile;
            LinkedHashMap<String, Object> variantData = new LinkedHashMap<String, Object>();
            variantData.put("variant", variant.name());
            variantData.putAll(global);
            Map<String, Object> variantFromGlobalFile = configData.remove(variant.name());
            if (variantFromGlobalFile != null) {
                variantData.putAll(variantFromGlobalFile);
            }
            if ((variantFromFile = PropertyFileIO.loadConfig(globalParams.name(), variant.files(), false).get(null)) != null) {
                variantData.putAll(variantFromFile);
            }
            variantData.putAll(variant.data());
            output.add(variantData);
        }
        if (!configData.isEmpty()) {
            throw new InvalidUserDataException("Unknown variants declared in file for template set " + globalParams.name() + ": " + String.valueOf(configData.keySet()));
        }
        return output;
    }

    private static Map<String, Map<String, Object>> loadConfig(String templateSetName, Set<Path> files, boolean useVariants) {
        LoadSettings settings = LoadSettings.builder().setLabel("Template set " + templateSetName).build();
        Load load = new Load(settings);
        HashMap<String, Map<String, Object>> templateParams = new HashMap<String, Map<String, Object>>();
        for (Path file : files) {
            if (!Files.isRegularFile(file, new LinkOption[0])) continue;
            try {
                BufferedReader reader = Files.newBufferedReader(file, StandardCharsets.UTF_8);
                try {
                    Object data = load.loadFromReader((Reader)reader);
                    PropertyFileIO.unmarshalData(templateParams, data, useVariants);
                }
                finally {
                    if (reader == null) continue;
                    reader.close();
                }
            }
            catch (YamlEngineException ex) {
                throw new InvalidUserDataException("Invalid input in " + String.valueOf(file), (Throwable)ex);
            }
            catch (IOException ex) {
                throw new GradleException("Failed to load data from " + String.valueOf(file), (Throwable)ex);
            }
        }
        return templateParams;
    }

    private static void unmarshalData(Map<@Nullable String, Map<@Nullable String, Object>> output, Object data, boolean useVariants) {
        Object variants;
        if (!(data instanceof Map)) {
            throw new InvalidUserDataException("Template data files must have a mapping as the root node");
        }
        Map dataMap = (Map)data;
        if (useVariants && (variants = dataMap.remove("variants")) != null) {
            if (!(variants instanceof Map)) {
                throw new InvalidUserDataException("value of 'variants' entry must be a mapping of String to Map<String, Object>");
            }
            for (Map.Entry variant : ((Map)variants).entrySet()) {
                if (!(variant.getValue() instanceof Map)) {
                    throw new InvalidUserDataException("Variant '" + String.valueOf(variant.getKey()) + "' was expected to have a mapping value, but it was a " + String.valueOf(variant.getValue().getClass()));
                }
                output.put(String.valueOf(variant.getKey()), PropertyFileIO.makeStringKeys((Map)variant.getValue()));
            }
        }
        output.put(null, PropertyFileIO.makeStringKeys((Map)data));
    }

    private static Map<@Nullable String, Object> makeStringKeys(Map<? extends @Nullable Object, ?> map) {
        LinkedHashMap<@Nullable String, Object> ret = new LinkedHashMap<String, Object>();
        for (Map.Entry<Object, ?> entry : map.entrySet()) {
            ret.put(entry.getKey() == null ? null : entry.getKey().toString(), entry.getValue());
        }
        return ret;
    }
}

