/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.indra;

import java.util.Objects;
import net.kyori.indra.JavaToolchainVersions;
import net.kyori.indra.api.model.ApplyTo;
import net.kyori.indra.api.model.ContinuousIntegration;
import net.kyori.indra.api.model.Issues;
import net.kyori.indra.api.model.License;
import net.kyori.indra.api.model.SourceCodeManagement;
import net.kyori.mammoth.Configurable;
import org.gradle.api.Action;
import org.gradle.api.provider.Property;
import org.gradle.api.publish.maven.MavenPublication;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IndraExtension {
    @NotNull
    public JavaToolchainVersions javaVersions();

    public void javaVersions(@NotNull Action<JavaToolchainVersions> var1);

    @NotNull
    public Property<ContinuousIntegration> ci();

    default public void ci(@NotNull ContinuousIntegration ci) {
        this.ci().set((Object)ci);
    }

    default public void ci(@NotNull Action<ContinuousIntegration.Builder> configureAction) {
        this.ci().set((Object)((ContinuousIntegration.Builder)Configurable.configure((Object)ContinuousIntegration.builder(), configureAction)).build());
    }

    default public void jenkins(@NotNull String url) {
        Objects.requireNonNull(url, "url");
        this.ci(ContinuousIntegration.builder().system("Jenkins").url(url).build());
    }

    @NotNull
    public Property<Issues> issues();

    default public void issues(@NotNull Issues issues) {
        this.issues().set((Object)issues);
    }

    default public void issues(@NotNull Action<Issues.Builder> configureAction) {
        this.issues().set((Object)((Issues.Builder)Configurable.configure((Object)Issues.builder(), configureAction)).build());
    }

    @NotNull
    public Property<SourceCodeManagement> scm();

    default public void scm(@NotNull SourceCodeManagement scm) {
        this.scm().set((Object)scm);
    }

    default public void scm(@NotNull Action<SourceCodeManagement.Builder> configureAction) {
        this.scm().set((Object)((SourceCodeManagement.Builder)Configurable.configure((Object)SourceCodeManagement.builder(), configureAction)).build());
    }

    @NotNull
    public Property<License> license();

    default public void license(@NotNull License license) {
        this.license().set((Object)license);
    }

    default public void license(@NotNull Action<License.Builder> configureAction) {
        this.license().set((Object)((License.Builder)Configurable.configure((Object)License.builder(), configureAction)).build());
    }

    default public void apache2License() {
        this.license(License.apache2());
    }

    default public void gpl3OnlyLicense() {
        this.license(License.gpl3Only());
    }

    default public void gpl3OrLaterLicense() {
        this.license(License.gpl3OrLater());
    }

    default public void lgpl3OnlyLicense() {
        this.license(License.lgpl3Only());
    }

    default public void lgpl3OrLaterLicense() {
        this.license(License.lgpl3OrLater());
    }

    default public void mitLicense() {
        this.license(License.mit());
    }

    default public void mpl2License() {
        this.license(License.mpl2());
    }

    default public void github(@NotNull String user, @NotNull String repo) {
        this.github(user, repo, null);
    }

    public void github(@NotNull String var1, @NotNull String var2, @Nullable Action<ApplyTo> var3);

    default public void gitlab(@NotNull String user, @NotNull String repo) {
        this.gitlab(user, repo, null);
    }

    public void gitlab(@NotNull String var1, @NotNull String var2, @Nullable Action<ApplyTo> var3);

    public void publishAllTo(@NotNull String var1, @NotNull String var2);

    public void publishReleasesTo(@NotNull String var1, @NotNull String var2);

    public void publishSnapshotsTo(@NotNull String var1, @NotNull String var2);

    public void configurePublications(@NotNull Action<MavenPublication> var1);

    @NotNull
    public Property<String> checkstyle();

    default public void checkstyle(@NotNull String checkstyleVersion) {
        this.checkstyle().set((Object)checkstyleVersion);
    }

    @NotNull
    public Property<Boolean> reproducibleBuilds();

    default public void reproducibleBuilds(boolean reproducibleBuilds) {
        this.reproducibleBuilds().set((Object)reproducibleBuilds);
    }

    @NotNull
    public Property<Boolean> includeJavaSoftwareComponentInPublications();

    default public void includeJavaSoftwareComponentInPublications(boolean include) {
        this.includeJavaSoftwareComponentInPublications().set((Object)include);
    }
}

