/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.indra.api.model;

import net.kyori.indra.api.model.LicenseImpl;
import org.immutables.value.Value;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Value.Immutable
public interface License {
    @NotNull
    public static Builder builder() {
        return new LicenseImpl.BuilderImpl();
    }

    @NotNull
    public static License apache2() {
        return License.builder().spdx("Apache-2.0").name("Apache License, Version 2.0").url("https://opensource.org/licenses/Apache-2.0").build();
    }

    @NotNull
    public static License gpl3Only() {
        return License.builder().spdx("GPL-3.0-only").name("GNU General Public License version 3").url("https://opensource.org/licenses/GPL-3.0").build();
    }

    @NotNull
    public static License gpl3OrLater() {
        return License.builder().spdx("GPL-3.0-or-later").name("GNU General Public License version 3 or later").url("https://opensource.org/licenses/GPL-3.0").build();
    }

    @NotNull
    public static License lgpl3Only() {
        return License.builder().spdx("LGPL-3.0-only").name("GNU Lesser General Public License version 3").url("https://opensource.org/licenses/LGPL-3.0").build();
    }

    @NotNull
    public static License lgpl3OrLater() {
        return License.builder().spdx("LGPL-3.0-or-later").name("GNU Lesser General Public License version 3 or later").url("https://opensource.org/licenses/LGPL-3.0").build();
    }

    @NotNull
    public static License mit() {
        return License.builder().spdx("MIT").name("The MIT License").url("https://opensource.org/licenses/MIT").build();
    }

    @NotNull
    public static License mpl2() {
        return License.builder().spdx("MPL-2.0").name("Mozilla Public License 2.0").url("https://opensource.org/licenses/MPL-2.0").build();
    }

    @Nullable
    public String spdx();

    @NotNull
    public String name();

    @NotNull
    public String url();

    public static interface Builder {
        @NotNull
        public Builder from(License var1);

        @NotNull
        public Builder spdx(@NotNull String var1);

        @NotNull
        public Builder name(@NotNull String var1);

        @NotNull
        public Builder url(@NotNull String var1);

        @NotNull
        public License build();
    }
}

