/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.indra.internal;

import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import net.kyori.indra.IndraExtension;
import net.kyori.indra.JavaToolchainVersions;
import net.kyori.indra.api.model.ApplyTo;
import net.kyori.indra.api.model.ContinuousIntegration;
import net.kyori.indra.api.model.Issues;
import net.kyori.indra.api.model.License;
import net.kyori.indra.api.model.SourceCodeManagement;
import net.kyori.indra.internal.JavaToolchainVersionsImpl;
import net.kyori.indra.repository.RemoteRepository;
import net.kyori.mammoth.Configurable;
import net.kyori.mammoth.Properties;
import org.gradle.api.Action;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.GradleException;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.process.CommandLineArgumentProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IndraExtensionImpl
implements IndraExtension {
    private static final String DEFAULT_CHECKSTYLE_VERSION = "9.3";
    private final Property<ContinuousIntegration> ci;
    private final Property<Issues> issues;
    private final Property<License> license;
    private final Property<SourceCodeManagement> scm;
    private final Property<Boolean> reproducibleBuilds;
    private final Property<String> checkstyle;
    private final Property<Boolean> includeJavaSoftwareComponentInPublications;
    private final JavaToolchainVersionsImpl javaVersions;
    final DomainObjectSet<RemoteRepository> repositories;
    final Set<Action<MavenPublication>> publishingActions = new HashSet<Action<MavenPublication>>();

    @Inject
    public IndraExtensionImpl(ObjectFactory objects) {
        this.ci = objects.property(ContinuousIntegration.class);
        this.issues = objects.property(Issues.class);
        this.license = objects.property(License.class);
        this.scm = objects.property(SourceCodeManagement.class);
        this.reproducibleBuilds = objects.property(Boolean.class).convention((Object)true);
        this.checkstyle = objects.property(String.class).convention((Object)DEFAULT_CHECKSTYLE_VERSION);
        this.includeJavaSoftwareComponentInPublications = objects.property(Boolean.class).convention((Object)true);
        this.javaVersions = (JavaToolchainVersionsImpl)objects.newInstance(JavaToolchainVersionsImpl.class, new Object[0]);
        this.repositories = objects.domainObjectSet(RemoteRepository.class);
    }

    @Override
    @NotNull
    public JavaToolchainVersions javaVersions() {
        return this.javaVersions;
    }

    @Override
    public void javaVersions(@NotNull Action<JavaToolchainVersions> action) {
        Configurable.configure((Object)this.javaVersions, action);
    }

    public CommandLineArgumentProvider previewFeatureArgumentProvider() {
        return new PreviewFeatureArgumentProvider(this.javaVersions.previewFeaturesEnabled());
    }

    @Override
    @NotNull
    public Property<ContinuousIntegration> ci() {
        return this.ci;
    }

    @Override
    @NotNull
    public Property<Issues> issues() {
        return this.issues;
    }

    @Override
    @NotNull
    public Property<SourceCodeManagement> scm() {
        return this.scm;
    }

    @Override
    @NotNull
    public Property<License> license() {
        return this.license;
    }

    @Override
    public void github(@NotNull String user, @NotNull String repo, @Nullable Action<ApplyTo> applicable) {
        ApplyTo options = (ApplyTo)Configurable.configureIfNonNull((Object)ApplyTo.defaults(), applicable);
        if (options.ci()) {
            this.ci((Action<ContinuousIntegration.Builder>)((Action)ci -> ci.system("GitHub Actions").url(String.format("https://github.com/%s/%s/actions", user, repo))));
        }
        if (options.issues()) {
            this.issues((Action<Issues.Builder>)((Action)issues -> issues.system("GitHub").url(String.format("https://github.com/%s/%s/issues", user, repo))));
        }
        if (options.scm()) {
            this.scm((Action<SourceCodeManagement.Builder>)((Action)scm -> scm.connection(String.format("scm:git:https://github.com/%s/%s.git", user, repo)).developerConnection(String.format("scm:git:ssh://git@github.com/%s/%s.git", user, repo)).url(String.format("https://github.com/%s/%s", user, repo))));
        }
        if (options.publishing()) {
            this.publishReleasesTo("githubPackages", String.format("https://maven.pkg.github.com/%s/%s", user, repo));
        }
    }

    @Override
    public void gitlab(@NotNull String user, @NotNull String repo, @Nullable Action<ApplyTo> applicable) {
        ApplyTo options = (ApplyTo)Configurable.configureIfNonNull((Object)ApplyTo.defaults(), applicable);
        if (options.ci()) {
            this.ci((Action<ContinuousIntegration.Builder>)((Action)ci -> ci.system("GitLab CI").url(String.format("https://gitlab.com/%s/%s/-/pipelines", user, repo))));
        }
        if (options.issues()) {
            this.issues((Action<Issues.Builder>)((Action)issues -> issues.system("GitLab").url(String.format("https://gitlab.com/%s/%s/-/issues", user, repo))));
        }
        if (options.scm()) {
            this.scm((Action<SourceCodeManagement.Builder>)((Action)scm -> scm.connection(String.format("scm:git:https://gitlab.com/%s/%s.git", user, repo)).developerConnection(String.format("scm:git:ssh://git@gitlab.com/%s/%s.git", user, repo)).url(String.format("https://gitlab.com/%s/%s", user, repo))));
        }
        if (options.publishing()) {
            throw new GradleException("Publishing cannot yet be automatically configured for GitLab projects");
        }
    }

    @Override
    public void publishAllTo(@NotNull String id, @NotNull String url) {
        this.repositories.add((Object)RemoteRepository.all(id, url));
    }

    @Override
    public void publishReleasesTo(@NotNull String id, @NotNull String url) {
        this.repositories.add((Object)RemoteRepository.releasesOnly(id, url));
    }

    @Override
    public void publishSnapshotsTo(@NotNull String id, @NotNull String url) {
        this.repositories.add((Object)RemoteRepository.snapshotsOnly(id, url));
    }

    @Override
    public void configurePublications(@NotNull Action<MavenPublication> action) {
        this.publishingActions.add(Objects.requireNonNull(action, "action"));
    }

    @Override
    @NotNull
    public Property<String> checkstyle() {
        return this.checkstyle;
    }

    @Override
    @NotNull
    public Property<Boolean> reproducibleBuilds() {
        return this.reproducibleBuilds;
    }

    @Override
    @NotNull
    public Property<Boolean> includeJavaSoftwareComponentInPublications() {
        return this.includeJavaSoftwareComponentInPublications;
    }

    static class PreviewFeatureArgumentProvider
    implements CommandLineArgumentProvider {
        private final Property<Boolean> previewFeaturesEnabledProp;

        PreviewFeatureArgumentProvider(Property<Boolean> previewFeaturesEnabledProp) {
            this.previewFeaturesEnabledProp = previewFeaturesEnabledProp;
        }

        public Iterable<String> asArguments() {
            if (((Boolean)((Property)Properties.finalized(this.previewFeaturesEnabledProp)).get()).booleanValue()) {
                return Collections.singletonList("--enable-preview");
            }
            return Collections.emptyList();
        }
    }
}

