/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.indra.internal.language;

import javax.inject.Inject;
import net.kyori.indra.internal.language.LanguageSupport;
import org.gradle.api.Action;
import org.gradle.api.JavaVersion;
import org.gradle.api.Project;
import org.gradle.api.plugins.GroovyPlugin;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.compile.GroovyCompile;
import org.gradle.jvm.toolchain.JavaLanguageVersion;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.jetbrains.annotations.NotNull;

public class GroovySupport
implements LanguageSupport {
    private static final String GROOVY = "groovy";
    private final JavaToolchainService toolchains;

    @Inject
    public GroovySupport(JavaToolchainService toolchains) {
        this.toolchains = toolchains;
    }

    @Override
    public void registerApplyCallback(@NotNull Project project, @NotNull Action<? super Project> callback) {
        project.getPlugins().withType(GroovyPlugin.class, $ -> callback.execute((Object)project));
    }

    @Override
    public void configureCompileTasks(Project project, SourceSet sourceSet, Provider<Integer> toolchainVersion, Provider<Integer> bytecodeVersion) {
        Provider launcher = this.toolchains.launcherFor(spec -> spec.getLanguageVersion().set(bytecodeVersion.map(v -> JavaLanguageVersion.of((int)v))));
        String expectedName = sourceSet.getCompileTaskName(GROOVY);
        project.getTasks().withType(GroovyCompile.class).matching(it -> it.getName().equals(expectedName)).configureEach(groovyCompile -> {
            groovyCompile.getOptions().getRelease().set(bytecodeVersion);
            if (HAS_GRADLE_7_2) {
                groovyCompile.getJavaLauncher().set(launcher);
            }
            String compatibility = JavaVersion.toVersion((Object)bytecodeVersion.get()).toString();
            groovyCompile.setSourceCompatibility(compatibility);
            groovyCompile.setTargetCompatibility(compatibility);
            groovyCompile.getGroovyOptions().setEncoding(DEFAULT_ENCODING);
        });
    }
}

