/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.indra.internal.language;

import java.util.Arrays;
import java.util.Collections;
import javax.inject.Inject;
import net.kyori.indra.internal.language.LanguageSupport;
import net.kyori.indra.util.Versioning;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.api.tasks.javadoc.Javadoc;
import org.gradle.external.javadoc.JavadocOptionFileOption;
import org.gradle.external.javadoc.MinimalJavadocOptions;
import org.gradle.external.javadoc.StandardJavadocDocletOptions;
import org.gradle.jvm.toolchain.JavaLanguageVersion;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.gradle.jvm.toolchain.JavadocTool;
import org.gradle.process.CommandLineArgumentProvider;
import org.jetbrains.annotations.NotNull;

public class JavaSupport
implements LanguageSupport {
    private final JavaToolchainService toolchains;

    @Inject
    public JavaSupport(JavaToolchainService toolchains) {
        this.toolchains = toolchains;
    }

    @Override
    public void registerApplyCallback(@NotNull Project project, @NotNull Action<? super Project> callback) {
        project.getPlugins().withType(JavaPlugin.class, $ -> callback.execute((Object)project));
    }

    @Override
    public void configureCompileTasks(@NotNull Project project, @NotNull SourceSet sourceSet, @NotNull Provider<Integer> toolchainVersion, @NotNull Provider<Integer> bytecodeVersion) {
        project.getTasks().named(sourceSet.getCompileJavaTaskName(), JavaCompile.class, task -> {
            CompileOptions options = task.getOptions();
            options.setEncoding(DEFAULT_ENCODING);
            task.getJavaCompiler().set(this.toolchains.compilerFor(spec -> spec.getLanguageVersion().set(toolchainVersion.map(v -> JavaLanguageVersion.of((int)v)))));
            options.getRelease().set(bytecodeVersion.zip(toolchainVersion, (bytecode, toolchain) -> {
                if (toolchain >= 9) {
                    return bytecode;
                }
                return null;
            }));
            options.getCompilerArgumentProviders().add(new IndraCompileArgumentProvider(toolchainVersion));
        });
    }

    @Override
    public void configureDocTasks(@NotNull Project project, @NotNull SourceSet sourceSet, @NotNull Provider<Integer> toolchainVersion, @NotNull Provider<Integer> targetVersion) {
        String taskName = sourceSet.getJavadocTaskName();
        Provider javadocTool = this.toolchains.javadocToolFor(spec -> spec.getLanguageVersion().set(toolchainVersion.map(v -> JavaLanguageVersion.of((int)v))));
        project.getTasks().withType(Javadoc.class).matching(t -> t.getName().equals(taskName)).configureEach(task -> {
            MinimalJavadocOptions minimalOpts = task.getOptions();
            minimalOpts.setEncoding(DEFAULT_ENCODING);
            task.getJavadocTool().set(javadocTool);
            if (minimalOpts instanceof StandardJavadocDocletOptions) {
                StandardJavadocDocletOptions options = (StandardJavadocDocletOptions)minimalOpts;
                options.charSet(DEFAULT_ENCODING);
                task.getInputs().property("targetVersion", (Object)targetVersion);
                task.doFirst((Action)new IndraJavadocPrepareAction(targetVersion, options));
            }
        });
    }

    private static String jdkApiDocs(int javaVersion) {
        String template = javaVersion >= 11 ? "https://docs.oracle.com/en/java/javase/%s/docs/api" : "https://docs.oracle.com/javase/%s/docs/api";
        return String.format(template, javaVersion);
    }

    static final class IndraJavadocPrepareAction
    implements Action<Task> {
        @NotNull
        private final Provider<Integer> targetVersion;
        private final JavadocOptionFileOption<String> release;

        IndraJavadocPrepareAction(@NotNull Provider<Integer> targetVersion, StandardJavadocDocletOptions initOptions) {
            this.targetVersion = targetVersion;
            this.release = initOptions.addStringOption("-release");
        }

        public void execute(Task t) {
            StandardJavadocDocletOptions options = (StandardJavadocDocletOptions)((Javadoc)t).getOptions();
            int target = (Integer)this.targetVersion.get();
            int actual = ((JavadocTool)((Javadoc)t).getJavadocTool().get()).getMetadata().getLanguageVersion().asInt();
            if (actual < 16) {
                options.links(new String[]{JavaSupport.jdkApiDocs(target)});
            }
            if (actual >= 9) {
                this.release.setValue((Object)Integer.toString(target));
            } else {
                options.setSource(Versioning.versionString(target));
            }
        }
    }

    static final class IndraCompileArgumentProvider
    implements CommandLineArgumentProvider {
        @NotNull
        private final Provider<Integer> toolchainVersion;

        public IndraCompileArgumentProvider(@NotNull Provider<Integer> toolchainVersion) {
            this.toolchainVersion = toolchainVersion;
        }

        public Iterable<String> asArguments() {
            if ((Integer)this.toolchainVersion.get() >= 9) {
                return Arrays.asList("-Xdoclint", "-Xdoclint:-missing");
            }
            return Collections.emptyList();
        }
    }
}

