/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.indra.internal.language;

import org.gradle.api.JavaVersion;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.jvm.toolchain.JavaLanguageVersion;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.tasks.KotlinCompile;
import org.jetbrains.kotlin.gradle.tasks.UsesKotlinJavaToolchain;

public final class KotlinShim {
    public static void configureCompileTasks(JavaToolchainService toolchains, @NotNull TaskContainer tasks, @NotNull SourceSet sourceSet, @NotNull Provider<Integer> toolchainVersion, @NotNull Provider<Integer> bytecodeVersion) {
        Provider launcher = toolchains.launcherFor(spec -> spec.getLanguageVersion().set(bytecodeVersion.map(v -> JavaLanguageVersion.of((int)v))));
        String expectedName = sourceSet.getCompileTaskName("kotlin");
        tasks.withType(UsesKotlinJavaToolchain.class).matching(it -> it.getName().equals(expectedName)).configureEach(task -> {
            task.getKotlinJavaToolchain().getToolchain().use(launcher);
            if (task instanceof KotlinCompile) {
                KotlinCompile kc = (KotlinCompile)task;
                task.getInputs().property("bytecodeVersion", (Object)bytecodeVersion);
                kc.getKotlinOptions().setJvmTarget(JavaVersion.toVersion((Object)bytecodeVersion.get()).toString());
            }
        });
    }
}

