/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.indra.repository;

import java.net.URI;
import net.kyori.indra.internal.ImmutablesStyle;
import net.kyori.indra.repository.RemoteRepositoryImpl;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.artifacts.repositories.MavenRepositoryContentDescriptor;
import org.immutables.value.Value;
import org.jetbrains.annotations.NotNull;

@ImmutablesStyle
@Value.Immutable(builder=false)
public interface RemoteRepository {
    public static final RemoteRepository SONATYPE_SNAPSHOTS = RemoteRepository.snapshotsOnly("sonatypeSnapshots", "https://oss.sonatype.org/content/repositories/snapshots/");

    @NotNull
    public static RemoteRepository all(String name, URI url) {
        return new RemoteRepositoryImpl(name, url, true, true);
    }

    @NotNull
    public static RemoteRepository all(String name, String url) {
        return RemoteRepository.all(name, URI.create(url));
    }

    @NotNull
    public static RemoteRepository releasesOnly(String name, URI url) {
        return new RemoteRepositoryImpl(name, url, true, false);
    }

    @NotNull
    public static RemoteRepository releasesOnly(String name, String url) {
        return RemoteRepository.releasesOnly(name, URI.create(url));
    }

    @NotNull
    public static RemoteRepository snapshotsOnly(String name, URI url) {
        return new RemoteRepositoryImpl(name, url, false, true);
    }

    @NotNull
    public static RemoteRepository snapshotsOnly(String name, String url) {
        return RemoteRepository.snapshotsOnly(name, URI.create(url));
    }

    @Value.Parameter
    @NotNull
    public String name();

    @Value.Parameter
    @NotNull
    public URI url();

    @Value.Default
    @Value.Parameter
    default public boolean releases() {
        return true;
    }

    @Value.Default
    @Value.Parameter
    default public boolean snapshots() {
        return true;
    }

    @NotNull
    default public MavenArtifactRepository addTo(RepositoryHandler handler) {
        return handler.maven(it -> {
            boolean snapshotsOnly;
            it.setName(this.name());
            it.setUrl(this.url());
            boolean releases = this.releases();
            boolean snapshots = this.snapshots();
            boolean releasesOnly = releases && !snapshots;
            boolean bl = snapshotsOnly = !releases && snapshots;
            if (releasesOnly) {
                it.mavenContent(MavenRepositoryContentDescriptor::releasesOnly);
            } else if (snapshotsOnly) {
                it.mavenContent(MavenRepositoryContentDescriptor::snapshotsOnly);
            }
        });
    }
}

