/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.indra.repository;

import java.net.URI;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import net.kyori.indra.repository.RemoteRepository;
import org.immutables.value.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@Generated(from="RemoteRepository", generator="Immutables")
@Immutable
final class RemoteRepositoryImpl
implements RemoteRepository {
    private final String name;
    private final URI url;
    private final boolean releases;
    private final boolean snapshots;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    public RemoteRepositoryImpl(@NotNull String name, @NotNull URI url, boolean releases, boolean snapshots) {
        this.name = Objects.requireNonNull(name, "name");
        this.url = Objects.requireNonNull(url, "url");
        this.releases = releases;
        this.snapshots = snapshots;
        this.initShim = null;
    }

    private RemoteRepositoryImpl(RemoteRepositoryImpl original, String name, URI url, boolean releases, boolean snapshots) {
        this.name = name;
        this.url = url;
        this.releases = releases;
        this.snapshots = snapshots;
        this.initShim = null;
    }

    private boolean releasesInitialize() {
        return RemoteRepository.super.releases();
    }

    private boolean snapshotsInitialize() {
        return RemoteRepository.super.snapshots();
    }

    @Override
    @NotNull
    public String name() {
        return this.name;
    }

    @Override
    @NotNull
    public URI url() {
        return this.url;
    }

    @Override
    public boolean releases() {
        InitShim shim = this.initShim;
        return shim != null ? shim.releases() : this.releases;
    }

    @Override
    public boolean snapshots() {
        InitShim shim = this.initShim;
        return shim != null ? shim.snapshots() : this.snapshots;
    }

    public final RemoteRepositoryImpl name(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new RemoteRepositoryImpl(this, newValue, this.url, this.releases, this.snapshots);
    }

    public final RemoteRepositoryImpl url(URI value) {
        if (this.url == value) {
            return this;
        }
        URI newValue = Objects.requireNonNull(value, "url");
        return new RemoteRepositoryImpl(this, this.name, newValue, this.releases, this.snapshots);
    }

    public final RemoteRepositoryImpl releases(boolean value) {
        if (this.releases == value) {
            return this;
        }
        return new RemoteRepositoryImpl(this, this.name, this.url, value, this.snapshots);
    }

    public final RemoteRepositoryImpl snapshots(boolean value) {
        if (this.snapshots == value) {
            return this;
        }
        return new RemoteRepositoryImpl(this, this.name, this.url, this.releases, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof RemoteRepositoryImpl && this.equalTo(0, (RemoteRepositoryImpl)another);
    }

    private boolean equalTo(int synthetic, RemoteRepositoryImpl another) {
        return this.name.equals(another.name) && this.url.equals(another.url) && this.releases == another.releases && this.snapshots == another.snapshots;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.url.hashCode();
        h += (h << 5) + Boolean.hashCode(this.releases);
        h += (h << 5) + Boolean.hashCode(this.snapshots);
        return h;
    }

    public String toString() {
        return "RemoteRepository{name=" + this.name + ", url=" + this.url + ", releases=" + this.releases + ", snapshots=" + this.snapshots + "}";
    }

    public static RemoteRepositoryImpl copyOf(RemoteRepository instance) {
        if (instance instanceof RemoteRepositoryImpl) {
            return (RemoteRepositoryImpl)instance;
        }
        return new RemoteRepositoryImpl(instance.name(), instance.url(), instance.releases(), instance.snapshots());
    }

    @Generated(from="RemoteRepository", generator="Immutables")
    private final class InitShim {
        private byte releasesBuildStage = 0;
        private boolean releases;
        private byte snapshotsBuildStage = 0;
        private boolean snapshots;

        private InitShim() {
        }

        boolean releases() {
            if (this.releasesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.releasesBuildStage == 0) {
                this.releasesBuildStage = (byte)-1;
                this.releases = RemoteRepositoryImpl.this.releasesInitialize();
                this.releasesBuildStage = 1;
            }
            return this.releases;
        }

        void releases(boolean releases) {
            this.releases = releases;
            this.releasesBuildStage = 1;
        }

        boolean snapshots() {
            if (this.snapshotsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.snapshotsBuildStage == 0) {
                this.snapshotsBuildStage = (byte)-1;
                this.snapshots = RemoteRepositoryImpl.this.snapshotsInitialize();
                this.snapshotsBuildStage = 1;
            }
            return this.snapshots;
        }

        void snapshots(boolean snapshots) {
            this.snapshots = snapshots;
            this.snapshotsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.releasesBuildStage == -1) {
                attributes.add("releases");
            }
            if (this.snapshotsBuildStage == -1) {
                attributes.add("snapshots");
            }
            return "Cannot build RemoteRepository, attribute initializers form cycle " + attributes;
        }
    }
}

