/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.indra.task;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import net.kyori.indra.internal.ModularityDetecter;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ModuleVisitor;

public abstract class CheckModuleExports
extends DefaultTask {
    private static final String MULTIRELEASE_PATH_PREFIX = "META-INF/versions/";

    @InputFile
    public abstract RegularFileProperty getCheckedModule();

    @Input
    public abstract SetProperty<String> getExclusions();

    public void exclude(String ... prefixes) {
        this.getExclusions().addAll((Object[])prefixes);
    }

    @TaskAction
    public void validateModule() throws ZipException, IOException {
        Set exclusions = (Set)this.getExclusions().get();
        HashSet<String> knownPackages = new HashSet<String>();
        HashSet<String> exports = new HashSet<String>();
        boolean moduleInfoSeen = false;
        File inspected = ((RegularFile)this.getCheckedModule().get()).getAsFile();
        if (!inspected.getName().endsWith(".jar")) {
            throw new InvalidUserDataException("Inspected file '" + inspected + "' was not a jar, when the CheckModuleExports task expected it to be");
        }
        try (ZipFile jar = new ZipFile(inspected);){
            Enumeration<? extends ZipEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                String packageName;
                ZipEntry check = entries.nextElement();
                if (ModularityDetecter.isModuleInfo(check.getName())) {
                    exports.addAll(this.exports(jar.getInputStream(check)));
                    moduleInfoSeen = true;
                    continue;
                }
                if (check.isDirectory() || (packageName = CheckModuleExports.packageNameOf(check.getName())) == null) continue;
                knownPackages.add(packageName);
            }
        }
        this.getLogger().debug("Detected exported packages: {}", exports);
        if (!moduleInfoSeen) {
            throw new InvalidUserDataException("Jar file " + inspected + " did not contain any module descriptor!");
        }
        Set<String> exportProblems = this.checkExports(exports, knownPackages, exclusions);
        if (!exportProblems.isEmpty()) {
            this.getLogger().error("Some packages in {} were not exported when they were expected to be:", (Object)inspected);
            for (String problem : exportProblems) {
                this.getLogger().error("- {}", (Object)problem);
            }
            throw new GradleException();
        }
    }

    private Set<String> checkExports(Set<String> exported, Set<String> known, Set<String> excludedPrefixes) {
        HashSet<String> problems = new HashSet<String>(known);
        problems.removeAll(exported);
        Iterator<String> it = known.iterator();
        block0: while (it.hasNext()) {
            String check = it.next();
            for (String prefix : excludedPrefixes) {
                if (!check.startsWith(prefix)) continue;
                it.remove();
                continue block0;
            }
        }
        return problems;
    }

    @VisibleForTesting
    @Nullable
    static String packageNameOf(@NotNull String file) {
        if (file.startsWith(MULTIRELEASE_PATH_PREFIX)) {
            int nextSlash = file.indexOf("/", MULTIRELEASE_PATH_PREFIX.length());
            if (nextSlash == -1) {
                return null;
            }
            file = file.substring(nextSlash + 1);
        } else if (file.startsWith("META-INF/")) {
            return null;
        }
        int lastSlash = file.lastIndexOf(47);
        if (lastSlash == -1) {
            return null;
        }
        return file.substring(0, lastSlash).replace('/', '.');
    }

    private Set<String> exports(InputStream is) throws IOException {
        ClassReader reader = new ClassReader(is);
        HashSet<String> exports = new HashSet<String>();
        reader.accept((ClassVisitor)new ModuleExportsVisitor(exports), 5);
        return Collections.unmodifiableSet(exports);
    }

    static final class ModuleExportsVisitor
    extends ClassVisitor {
        private static final int ASMAPI = 589824;
        private final Set<String> exports;

        public ModuleExportsVisitor(Set<String> exports) {
            super(589824);
            this.exports = exports;
        }

        public ModuleVisitor visitModule(String name, int access, String version) {
            return new Exports(super.visitModule(name, access, version));
        }

        final class Exports
        extends ModuleVisitor {
            Exports(ModuleVisitor parent) {
                super(589824, parent);
            }

            public void visitExport(String packaze, int access, String ... modules) {
                ModuleExportsVisitor.this.exports.add(packaze.replace('/', '.'));
                super.visitExport(packaze, access, modules);
            }
        }
    }
}

