/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.indra;

import java.io.File;
import java.util.HashMap;
import net.kyori.indra.Indra;
import net.kyori.indra.IndraExtension;
import net.kyori.mammoth.ProjectPlugin;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.plugins.quality.Checkstyle;
import org.gradle.api.plugins.quality.CheckstyleExtension;
import org.gradle.api.plugins.quality.CheckstylePlugin;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IndraCheckstylePlugin
implements ProjectPlugin {
    public static final String CHECKSTYLE_ALL_TASK = "checkstyleAll";
    private static final String CHECKSTYLE_CONFIGURATION = "checkstyle";

    @Nullable
    public GradleVersion minimumGradleVersion() {
        return Indra.MINIMUM_SUPPORTED;
    }

    public void apply(@NotNull Project project, @NotNull PluginContainer plugins, @NotNull ExtensionContainer extensions, @NotNull TaskContainer tasks) {
        plugins.apply(CheckstylePlugin.class);
        tasks.register(CHECKSTYLE_ALL_TASK, task -> {
            task.setGroup("verification");
            task.setDescription("Execute checkstyle checks for all source sets");
            task.dependsOn(new Object[]{tasks.withType(Checkstyle.class)});
        });
        ObjectFactory objects = project.getObjects();
        tasks.withType(Checkstyle.class).configureEach(check -> check.setClasspath((FileCollection)objects.fileCollection()));
        project.afterEvaluate(p -> {
            IndraExtension indra = Indra.extension(p.getExtensions());
            p.getExtensions().configure(CheckstyleExtension.class, cs -> {
                cs.setToolVersion((String)indra.checkstyle().get());
                File checkstyleDir = p.getRootProject().file((Object)".checkstyle");
                cs.getConfigDirectory().set(checkstyleDir);
                HashMap<String, Object> props = new HashMap<String, Object>();
                props.put("configDirectory", checkstyleDir);
                props.put("severity", "error");
                cs.setConfigProperties(props);
                p.getDependencies().getConstraints().add(CHECKSTYLE_CONFIGURATION, (Object)"com.puppycrawl.tools:checkstyle", c -> c.version(v -> v.require((String)indra.checkstyle().get())));
            });
        });
    }
}

