/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.indra.internal;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import net.kyori.indra.IndraExtension;
import net.kyori.indra.JavaToolchainVersions;
import net.kyori.indra.api.model.ApplyTo;
import net.kyori.indra.api.model.ContinuousIntegration;
import net.kyori.indra.api.model.Issues;
import net.kyori.indra.api.model.License;
import net.kyori.indra.api.model.SourceCodeManagement;
import net.kyori.indra.internal.JavaToolchainVersionsImpl;
import net.kyori.indra.internal.RemoteRepository;
import net.kyori.mammoth.Configurable;
import net.kyori.mammoth.Properties;
import org.gradle.api.Action;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.GradleException;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.plugins.signing.SigningExtension;
import org.gradle.process.CommandLineArgumentProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IndraExtensionImpl
implements IndraExtension {
    private static final Logger LOGGER = Logging.getLogger(IndraExtensionImpl.class);
    private static final String DEFAULT_CHECKSTYLE_VERSION = "12.0.1";
    private final Property<ContinuousIntegration> ci;
    private final Property<Issues> issues;
    private final Property<License> license;
    private final Property<SourceCodeManagement> scm;
    private final Property<Boolean> reproducibleBuilds;
    private final Property<String> checkstyle;
    private final Property<Boolean> includeJavaSoftwareComponentInPublications;
    private final JavaToolchainVersionsImpl javaVersions;
    final DomainObjectSet<RemoteRepository> repositories;
    private final transient ProviderFactory providers;
    private final transient ProjectLayout layout;
    @Nullable
    private transient Action<SigningExtension> signingAction;
    private transient SigningExtension signingExtension;
    private boolean alternateSigningConfigured;
    final Set<Action<MavenPublication>> publishingActions = new HashSet<Action<MavenPublication>>();

    @Inject
    public IndraExtensionImpl(ObjectFactory objects, ProviderFactory providers, ProjectLayout layout) {
        this.providers = providers;
        this.layout = layout;
        this.ci = objects.property(ContinuousIntegration.class);
        this.issues = objects.property(Issues.class);
        this.license = objects.property(License.class);
        this.scm = objects.property(SourceCodeManagement.class);
        this.reproducibleBuilds = objects.property(Boolean.class).convention((Object)true);
        this.checkstyle = objects.property(String.class).convention((Object)DEFAULT_CHECKSTYLE_VERSION);
        this.includeJavaSoftwareComponentInPublications = objects.property(Boolean.class).convention((Object)true);
        this.javaVersions = (JavaToolchainVersionsImpl)objects.newInstance(JavaToolchainVersionsImpl.class, new Object[0]);
        this.repositories = objects.domainObjectSet(RemoteRepository.class);
    }

    @Override
    @NotNull
    public JavaToolchainVersions javaVersions() {
        return this.javaVersions;
    }

    @Override
    public void javaVersions(@NotNull Action<JavaToolchainVersions> action) {
        Configurable.configure((Object)this.javaVersions, action);
    }

    public CommandLineArgumentProvider previewFeatureArgumentProvider() {
        return new PreviewFeatureArgumentProvider(this.javaVersions.previewFeaturesEnabled());
    }

    @Override
    @NotNull
    public Property<ContinuousIntegration> ci() {
        return this.ci;
    }

    @Override
    @NotNull
    public Property<Issues> issues() {
        return this.issues;
    }

    @Override
    @NotNull
    public Property<SourceCodeManagement> scm() {
        return this.scm;
    }

    @Override
    @NotNull
    public Property<License> license() {
        return this.license;
    }

    @Override
    public void github(@NotNull String user, @NotNull String repo, @Nullable Action<ApplyTo> applicable) {
        ApplyTo options = (ApplyTo)Configurable.configureIfNonNull((Object)ApplyTo.defaults(), applicable);
        if (options.ci()) {
            this.ci((Action<ContinuousIntegration.Builder>)((Action)ci -> ci.system("GitHub Actions").url(String.format("https://github.com/%s/%s/actions", user, repo))));
        }
        if (options.issues()) {
            this.issues((Action<Issues.Builder>)((Action)issues -> issues.system("GitHub").url(String.format("https://github.com/%s/%s/issues", user, repo))));
        }
        if (options.scm()) {
            this.scm((Action<SourceCodeManagement.Builder>)((Action)scm -> scm.connection(String.format("scm:git:https://github.com/%s/%s.git", user, repo)).developerConnection(String.format("scm:git:ssh://git@github.com/%s/%s.git", user, repo)).url(String.format("https://github.com/%s/%s", user, repo))));
        }
        if (options.publishing()) {
            this.publishReleasesTo("githubPackages", String.format("https://maven.pkg.github.com/%s/%s", user, repo));
        }
    }

    @Override
    public void gitlab(@NotNull String user, @NotNull String repo, @Nullable Action<ApplyTo> applicable) {
        ApplyTo options = (ApplyTo)Configurable.configureIfNonNull((Object)ApplyTo.defaults(), applicable);
        if (options.ci()) {
            this.ci((Action<ContinuousIntegration.Builder>)((Action)ci -> ci.system("GitLab CI").url(String.format("https://gitlab.com/%s/%s/-/pipelines", user, repo))));
        }
        if (options.issues()) {
            this.issues((Action<Issues.Builder>)((Action)issues -> issues.system("GitLab").url(String.format("https://gitlab.com/%s/%s/-/issues", user, repo))));
        }
        if (options.scm()) {
            this.scm((Action<SourceCodeManagement.Builder>)((Action)scm -> scm.connection(String.format("scm:git:https://gitlab.com/%s/%s.git", user, repo)).developerConnection(String.format("scm:git:ssh://git@gitlab.com/%s/%s.git", user, repo)).url(String.format("https://gitlab.com/%s/%s", user, repo))));
        }
        if (options.publishing()) {
            throw new GradleException("Publishing cannot yet be automatically configured for GitLab projects");
        }
    }

    @Override
    public void forgejo(URI baseUrl, @NotNull String user, @NotNull String repo, @Nullable Action<ApplyTo> applicable) {
        ApplyTo options = (ApplyTo)Configurable.configureIfNonNull((Object)ApplyTo.defaults(), applicable);
        if (options.ci()) {
            this.ci((Action<ContinuousIntegration.Builder>)((Action)ci -> ci.system("Forgejo Actions").url(baseUrl.resolve("%s/%s/actions".formatted(user, repo)).toString())));
        }
        if (options.issues()) {
            this.issues((Action<Issues.Builder>)((Action)issues -> issues.system("Forgejo").url(baseUrl.resolve("%s/%s/issues".formatted(user, repo)).toString())));
        }
        if (options.scm()) {
            this.scm((Action<SourceCodeManagement.Builder>)((Action)scm -> scm.connection("scm:git:" + baseUrl.resolve("/%s/%s.git".formatted(user, repo))).developerConnection("scm:git:ssh://git@%s/%s/%s.git".formatted(baseUrl.getHost(), user, repo)).url(baseUrl.resolve("%s/%s".formatted(user, repo)).toString())));
        }
        if (options.publishing()) {
            this.publishReleasesTo("forgejoPackages", baseUrl.resolve("/api/packages/%s/maven".formatted(user)).toString());
        }
    }

    @Override
    public void publishAllTo(@NotNull String id, @NotNull String url) {
        this.repositories.add((Object)RemoteRepository.all(id, url));
    }

    @Override
    public void publishReleasesTo(@NotNull String id, @NotNull String url) {
        this.repositories.add((Object)RemoteRepository.releasesOnly(id, url));
    }

    @Override
    public void publishSnapshotsTo(@NotNull String id, @NotNull String url) {
        this.repositories.add((Object)RemoteRepository.snapshotsOnly(id, url));
    }

    @Override
    public void configurePublications(@NotNull Action<MavenPublication> action) {
        this.publishingActions.add(Objects.requireNonNull(action, "action"));
    }

    @Override
    @NotNull
    public Property<String> checkstyle() {
        return this.checkstyle;
    }

    @Override
    @NotNull
    public Property<Boolean> reproducibleBuilds() {
        return this.reproducibleBuilds;
    }

    @Override
    @NotNull
    public Property<Boolean> includeJavaSoftwareComponentInPublications() {
        return this.includeJavaSoftwareComponentInPublications;
    }

    @Override
    public void signWithKeyFromPrefixedProperties(String prefix) {
        if (prefix.isEmpty()) {
            throw new IllegalArgumentException("Prefix '" + prefix + "' must not be empty");
        }
        this.signWithKeyFromProperties(prefix + "SigningKey", prefix + "SigningPassword");
    }

    @Override
    public void signWithKeyFromProperties(String keyFileOrContentsProperty, String keyPasswordProperty) {
        Provider keyFileOrContents = this.providers.gradleProperty(keyFileOrContentsProperty);
        Provider keyPassword = this.providers.gradleProperty(keyPasswordProperty);
        if (!keyFileOrContents.isPresent()) {
            LOGGER.info("Skipping configuring file-based signing because property '{}' had no value", (Object)keyFileOrContentsProperty);
            return;
        }
        if (!keyPassword.isPresent()) {
            LOGGER.info("Skipping configuring file-based signing because property '{}' had no value", (Object)keyPasswordProperty);
            return;
        }
        this.alternateSigningConfigured = true;
        if (this.signingExtension != null) {
            this.configureSigningExtension(this.signingExtension, (String)keyFileOrContents.get(), (String)keyPassword.get());
        } else {
            this.signingAction = ext -> this.configureSigningExtension((SigningExtension)ext, (String)keyFileOrContents.get(), (String)keyPassword.get());
        }
    }

    private void configureSigningExtension(SigningExtension extension, String keyFileOrContents, String keyPassword) {
        File keyFile = this.layout.getProjectDirectory().file(keyFileOrContents).getAsFile();
        if (keyFile.exists()) {
            StringBuilder contents = new StringBuilder();
            try (BufferedReader reader = Files.newBufferedReader(keyFile.toPath(), StandardCharsets.UTF_8);){
                int read;
                char[] buf = new char[2048];
                while ((read = reader.read(buf)) != -1) {
                    contents.append(buf, 0, read);
                }
            }
            catch (IOException ex) {
                throw new GradleException("Failed to read signing key file", (Throwable)ex);
            }
            extension.useInMemoryPgpKeys(contents.toString(), keyPassword);
        } else {
            extension.useInMemoryPgpKeys(keyFileOrContents, keyPassword);
        }
    }

    public void initSigningExtension(SigningExtension extension) {
        if (this.signingAction != null) {
            try {
                this.signingAction.execute((Object)extension);
            }
            finally {
                this.signingAction = null;
            }
        }
        this.signingExtension = extension;
    }

    public boolean alternateSigningConfigured() {
        return this.alternateSigningConfigured;
    }

    static class PreviewFeatureArgumentProvider
    implements CommandLineArgumentProvider {
        private final Property<Boolean> previewFeaturesEnabledProp;

        PreviewFeatureArgumentProvider(Property<Boolean> previewFeaturesEnabledProp) {
            this.previewFeaturesEnabledProp = previewFeaturesEnabledProp;
        }

        public Iterable<String> asArguments() {
            if (((Boolean)((Property)Properties.finalized(this.previewFeaturesEnabledProp)).get()).booleanValue()) {
                return Collections.singletonList("--enable-preview");
            }
            return Collections.emptyList();
        }
    }
}

