/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.indra.internal;

import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;

public final class PropertyUtils {
    private static final Logger LOGGER = Logging.getLogger(PropertyUtils.class);

    private PropertyUtils() {
    }

    public static <V> void applyFinalizingAndLogging(Property<? super V> property, Provider<? extends V> value, String message) {
        property.finalizeValueOnRead();
        property.set(PropertyUtils.logValueComputation(value, message));
    }

    public static <V> Provider<V> logValueComputation(Provider<? extends V> provider, String message) {
        return provider.map(value -> {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Computing value for property with value {}: {}", new Object[]{value, message, new Exception()});
            }
            return value;
        });
    }

    public static <V> V getAndLog(Provider<V> provider, String message) {
        Object value = provider.get();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Computing value for property with value {}: {}", new Object[]{value, message, new Exception()});
        }
        return (V)value;
    }
}

