/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.indra.internal.language;

import javax.inject.Inject;
import net.kyori.indra.internal.PropertyUtils;
import net.kyori.indra.internal.language.LanguageSupport;
import org.gradle.api.Action;
import org.gradle.api.JavaVersion;
import org.gradle.api.Project;
import org.gradle.api.plugins.GroovyPlugin;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.compile.GroovyCompile;
import org.gradle.jvm.toolchain.JavaLanguageVersion;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.jetbrains.annotations.NotNull;

public class GroovySupport
implements LanguageSupport {
    private static final String GROOVY = "groovy";
    private final JavaToolchainService toolchains;

    @Inject
    public GroovySupport(JavaToolchainService toolchains) {
        this.toolchains = toolchains;
    }

    @Override
    public void registerApplyCallback(@NotNull Project project, @NotNull Action<? super Project> callback) {
        project.getPlugins().withType(GroovyPlugin.class, $ -> callback.execute((Object)project));
    }

    @Override
    public void configureCompileTasks(@NotNull Project project, @NotNull SourceSet sourceSet, @NotNull Provider<Integer> toolchainVersion, @NotNull Provider<Integer> bytecodeVersion) {
        Provider launcher = this.toolchains.launcherFor(spec -> spec.getLanguageVersion().set(bytecodeVersion.map(JavaLanguageVersion::of)));
        String expectedName = sourceSet.getCompileTaskName(GROOVY);
        project.getTasks().withType(GroovyCompile.class).matching(it -> it.getName().equals(expectedName)).configureEach(groovyCompile -> {
            PropertyUtils.applyFinalizingAndLogging(groovyCompile.getOptions().getRelease(), bytecodeVersion, "groovy release");
            if (HAS_GRADLE_7_2) {
                PropertyUtils.applyFinalizingAndLogging(groovyCompile.getJavaLauncher(), launcher, "groovy toolchain");
            }
            String compatibility = JavaVersion.toVersion(PropertyUtils.getAndLog(bytecodeVersion, groovyCompile.getName())).toString();
            groovyCompile.setSourceCompatibility(compatibility);
            groovyCompile.setTargetCompatibility(compatibility);
            groovyCompile.getGroovyOptions().setEncoding(DEFAULT_ENCODING);
        });
    }
}

