/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.indra.internal.language;

import java.util.Arrays;
import java.util.Collections;
import javax.inject.Inject;
import net.kyori.indra.internal.PropertyUtils;
import net.kyori.indra.internal.language.LanguageSupport;
import net.kyori.indra.util.Versioning;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.api.tasks.javadoc.Javadoc;
import org.gradle.external.javadoc.JavadocOptionFileOption;
import org.gradle.external.javadoc.MinimalJavadocOptions;
import org.gradle.external.javadoc.StandardJavadocDocletOptions;
import org.gradle.jvm.toolchain.JavaLanguageVersion;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.gradle.jvm.toolchain.JavadocTool;
import org.gradle.process.CommandLineArgumentProvider;
import org.jetbrains.annotations.NotNull;

public class JavaSupport
implements LanguageSupport {
    private final JavaToolchainService toolchains;

    @Inject
    public JavaSupport(JavaToolchainService toolchains) {
        this.toolchains = toolchains;
    }

    @Override
    public void registerApplyCallback(@NotNull Project project, @NotNull Action<? super Project> callback) {
        project.getPlugins().withType(JavaPlugin.class, $ -> callback.execute((Object)project));
    }

    @Override
    public void configureCompileTasks(@NotNull Project project, @NotNull SourceSet sourceSet, @NotNull Provider<Integer> toolchainVersion, @NotNull Provider<Integer> bytecodeVersion) {
        project.getTasks().named(sourceSet.getCompileJavaTaskName(), JavaCompile.class, task -> {
            CompileOptions options = task.getOptions();
            options.setEncoding(DEFAULT_ENCODING);
            PropertyUtils.applyFinalizingAndLogging(task.getJavaCompiler(), this.toolchains.compilerFor(spec -> spec.getLanguageVersion().set(toolchainVersion.map(JavaLanguageVersion::of))), task.getName());
            PropertyUtils.applyFinalizingAndLogging(options.getRelease(), toolchainVersion.flatMap(toolchain -> toolchain >= 9 ? bytecodeVersion : null), task.getName());
            String compatibility = Versioning.versionString((Integer)PropertyUtils.getAndLog(bytecodeVersion, task.getName()));
            task.setSourceCompatibility(compatibility);
            task.setTargetCompatibility(compatibility);
            options.getCompilerArgumentProviders().add(new IndraCompileArgumentProvider(PropertyUtils.logValueComputation(toolchainVersion, task.getName())));
        });
    }

    @Override
    public void configureDocTasks(@NotNull Project project, @NotNull SourceSet sourceSet, @NotNull Provider<Integer> toolchainVersion, @NotNull Provider<Integer> targetVersion) {
        String taskName = sourceSet.getJavadocTaskName();
        Provider javadocTool = this.toolchains.javadocToolFor(spec -> PropertyUtils.applyFinalizingAndLogging(spec.getLanguageVersion(), toolchainVersion.map(JavaLanguageVersion::of), "javadoc"));
        project.getTasks().withType(Javadoc.class).matching(t -> t.getName().equals(taskName)).configureEach(task -> {
            MinimalJavadocOptions minimalOpts = task.getOptions();
            minimalOpts.setEncoding(DEFAULT_ENCODING);
            task.getJavadocTool().set(javadocTool);
            if (minimalOpts instanceof StandardJavadocDocletOptions) {
                StandardJavadocDocletOptions options = (StandardJavadocDocletOptions)minimalOpts;
                options.charSet(DEFAULT_ENCODING);
                task.getInputs().property("targetVersion", (Object)targetVersion);
                task.doFirst((Action)new IndraJavadocPrepareAction(PropertyUtils.logValueComputation(targetVersion, task.getName()), options));
            }
        });
    }

    private static String jdkApiDocs(int javaVersion) {
        String template = javaVersion >= 11 ? "https://docs.oracle.com/en/java/javase/%s/docs/api" : "https://docs.oracle.com/javase/%s/docs/api";
        return String.format(template, javaVersion);
    }

    static final class IndraJavadocPrepareAction
    implements Action<Task> {
        @NotNull
        private final Provider<Integer> targetVersion;
        private final JavadocOptionFileOption<String> release;

        IndraJavadocPrepareAction(@NotNull Provider<Integer> targetVersion, StandardJavadocDocletOptions initOptions) {
            this.targetVersion = targetVersion;
            this.release = initOptions.addStringOption("-release");
        }

        public void execute(@NotNull Task t) {
            StandardJavadocDocletOptions options = (StandardJavadocDocletOptions)((Javadoc)t).getOptions();
            int target = (Integer)this.targetVersion.get();
            int actual = ((JavadocTool)((Javadoc)t).getJavadocTool().get()).getMetadata().getLanguageVersion().asInt();
            if (actual < 16) {
                options.links(new String[]{JavaSupport.jdkApiDocs(target)});
            }
            if (actual >= 9) {
                this.release.setValue((Object)Integer.toString(target));
            } else {
                options.setSource(Versioning.versionString(target));
            }
        }
    }

    static final class IndraCompileArgumentProvider
    implements CommandLineArgumentProvider {
        @NotNull
        private final Provider<Integer> toolchainVersion;

        IndraCompileArgumentProvider(@NotNull Provider<Integer> toolchainVersion) {
            this.toolchainVersion = toolchainVersion;
        }

        public Iterable<String> asArguments() {
            if ((Integer)this.toolchainVersion.get() >= 9) {
                return Arrays.asList("-Xdoclint", "-Xdoclint:-missing");
            }
            return Collections.emptyList();
        }
    }
}

