/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.indra.internal.language;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import javax.inject.Inject;
import net.kyori.indra.internal.PropertyUtils;
import net.kyori.indra.internal.language.LanguageSupport;
import net.kyori.indra.util.Versioning;
import org.gradle.api.Action;
import org.gradle.api.JavaVersion;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.plugins.scala.ScalaPlugin;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.scala.ScalaCompile;
import org.gradle.api.tasks.scala.ScalaCompileOptions;
import org.gradle.jvm.toolchain.JavaLanguageVersion;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.jetbrains.annotations.NotNull;

public class ScalaSupport
implements LanguageSupport {
    private final JavaToolchainService toolchains;

    @Inject
    public ScalaSupport(JavaToolchainService toolchains) {
        this.toolchains = toolchains;
    }

    @Override
    public void registerApplyCallback(@NotNull Project project, @NotNull Action<? super Project> callback) {
        project.getPlugins().withType(ScalaPlugin.class, $ -> callback.execute((Object)project));
    }

    @Override
    public void configureCompileTasks(@NotNull Project project, @NotNull SourceSet sourceSet, @NotNull Provider<Integer> toolchainVersion, @NotNull Provider<Integer> bytecodeVersion) {
        Provider launcher = this.toolchains.launcherFor(spec -> PropertyUtils.applyFinalizingAndLogging(spec.getLanguageVersion(), bytecodeVersion.map(JavaLanguageVersion::of), "scala launcher"));
        String expectedName = sourceSet.getCompileTaskName("scala");
        project.getTasks().withType(ScalaCompile.class).matching(it -> it.getName().equals(expectedName)).configureEach(task -> {
            ScalaCompileOptions options = task.getScalaCompileOptions();
            options.setEncoding(DEFAULT_ENCODING);
            options.setDeprecation(true);
            if (HAS_GRADLE_7_2) {
                PropertyUtils.applyFinalizingAndLogging(task.getJavaLauncher(), launcher, task.getName());
            } else {
                String compatibility = JavaVersion.toVersion(PropertyUtils.getAndLog(bytecodeVersion, task.getName())).toString();
                task.setSourceCompatibility(compatibility);
                task.setTargetCompatibility(compatibility);
                task.getOptions().getRelease().set(bytecodeVersion);
                task.doFirst((Action)new ParameterAdder(bytecodeVersion));
            }
        });
    }

    static class ParameterAdder
    implements Action<Task> {
        @NotNull
        private final Provider<Integer> target;

        public ParameterAdder(@NotNull Provider<Integer> target) {
            this.target = target;
        }

        public void execute(@NotNull Task task) {
            ArrayList<CallSite> options = ((ScalaCompile)task).getScalaCompileOptions().getAdditionalParameters();
            if (options != null && options.stream().anyMatch(opt -> opt.startsWith("-target:"))) {
                return;
            }
            if (options == null) {
                options = new ArrayList<CallSite>();
                ((ScalaCompile)task).getScalaCompileOptions().setAdditionalParameters(options);
            }
            options.add((CallSite)((Object)("-target:" + Versioning.versionString((Integer)this.target.get()))));
        }
    }
}

