/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.indra.crossdoc;

import java.io.File;
import net.kyori.indra.crossdoc.CopyJavadoc;
import net.kyori.indra.crossdoc.CrossdocExtension;
import net.kyori.indra.crossdoc.CrossdocExtensionImpl;
import net.kyori.indra.crossdoc.GenerateOfflineLinks;
import net.kyori.indra.crossdoc.JavadocPackaging;
import net.kyori.mammoth.ProjectPlugin;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.attributes.Bundling;
import org.gradle.api.attributes.Category;
import org.gradle.api.attributes.DocsType;
import org.gradle.api.attributes.Usage;
import org.gradle.api.file.RegularFile;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.plugins.JavaLibraryPlugin;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.javadoc.Javadoc;
import org.jetbrains.annotations.NotNull;

public class CrossdocPlugin
implements ProjectPlugin {
    public static final String GENERATE_OFFLINE_LINKS_TASK_NAME = "generateOfflineLinks";
    public static final String COPY_JAVADOC_TASK_NAME = "copyJavadoc";
    public static final String OFFLINE_LINKED_JAVADOC_CONFIGURATION_NAME = "offlineLinkedJavadoc";
    public static final String EXTENSION_NAME = "indraCrossdoc";

    public void apply(@NotNull Project project, @NotNull PluginContainer plugins, @NotNull ExtensionContainer extensions, @NotNull TaskContainer tasks) {
        this.prepareAttributeSchema(project.getDependencies());
        CrossdocExtension extension = this.createExtension(project);
        plugins.withType(JavaLibraryPlugin.class, $ -> {
            NamedDomainObjectProvider<Configuration> offlineLinkedJavadoc = this.createOfflineLinkedResolvableConfiguration(project);
            this.addUnpackedResultToJavadocConfiguration(project);
            this.configureJavadocTask(project, extension, offlineLinkedJavadoc);
            this.registerCopyTask(project, extension);
        });
        project.afterEvaluate(p -> {
            if (!this.hasJavadocTaskAndConfiguration(project)) {
                throw new InvalidUserDataException("The indra crossdoc plugin requires javadoc and the javadocElements configuration to be set up, but they weren't.\n\nDid you forget to call java.withJavadocJar() in your buildscript?");
            }
        });
    }

    private CrossdocExtension createExtension(Project project) {
        return (CrossdocExtension)project.getExtensions().create(CrossdocExtension.class, EXTENSION_NAME, CrossdocExtensionImpl.class, new Object[]{project});
    }

    private void addUnpackedResultToJavadocConfiguration(Project project) {
        project.getConfigurations().matching(c -> c.getName().equals("javadocElements")).configureEach(c -> c.getOutgoing().getVariants().create("files", v -> {
            TaskProvider javadocTask = project.getTasks().named("javadoc", Javadoc.class);
            v.artifact((Object)javadocTask.map(it -> it.getDestinationDir()), a -> {
                a.builtBy(new Object[]{javadocTask});
                a.setType("directory");
            });
            v.getAttributes().attribute(JavadocPackaging.JAVADOC_PACKAGING_ATTRIBUTE, (Object)((JavadocPackaging)project.getObjects().named(JavadocPackaging.class, "directory")));
        }));
    }

    private NamedDomainObjectProvider<Configuration> createOfflineLinkedResolvableConfiguration(Project project) {
        ObjectFactory objects = project.getObjects();
        NamedDomainObjectProvider offlineLinkedJavadoc = project.getConfigurations().register(OFFLINE_LINKED_JAVADOC_CONFIGURATION_NAME, c -> {
            c.setCanBeResolved(true);
            c.setCanBeConsumed(false);
            c.attributes(a -> {
                a.attribute(Category.CATEGORY_ATTRIBUTE, (Object)((Category)objects.named(Category.class, "documentation")));
                a.attribute(Bundling.BUNDLING_ATTRIBUTE, (Object)((Bundling)objects.named(Bundling.class, "external")));
                a.attribute(DocsType.DOCS_TYPE_ATTRIBUTE, (Object)((DocsType)objects.named(DocsType.class, "javadoc")));
                a.attribute(Usage.USAGE_ATTRIBUTE, (Object)((Usage)objects.named(Usage.class, "java-runtime")));
                a.attribute(JavadocPackaging.JAVADOC_PACKAGING_ATTRIBUTE, (Object)((JavadocPackaging)objects.named(JavadocPackaging.class, "directory")));
            });
            c.extendsFrom(new Configuration[]{project.getConfigurations().getByName("apiElements")});
        });
        return offlineLinkedJavadoc;
    }

    private void prepareAttributeSchema(DependencyHandler handler) {
        handler.getAttributesSchema().attribute(JavadocPackaging.JAVADOC_PACKAGING_ATTRIBUTE);
    }

    private void configureJavadocTask(Project project, CrossdocExtension extension, NamedDomainObjectProvider<Configuration> offlineLinkedJavadoc) {
        Provider jdLinks = offlineLinkedJavadoc.map(oLJ -> oLJ.getIncoming().artifactView(view -> {
            view.componentFilter(c -> c instanceof ProjectComponentIdentifier && ((ProjectComponentIdentifier)c).getBuild().isCurrentBuild());
            view.setLenient(true);
        }).getArtifacts());
        TaskProvider generateLinks = project.getTasks().register(GENERATE_OFFLINE_LINKS_TASK_NAME, GenerateOfflineLinks.class, t -> {
            t.getLinkBaseUrl().set(extension.baseUrl());
            t.getLinkableArtifactFiles().from(new Object[]{jdLinks.map(ArtifactCollection::getArtifactFiles)});
            t.getLinkableArtifacts().set(jdLinks.flatMap(ArtifactCollection::getResolvedArtifacts));
            t.getUrlProvider().set(extension.projectDocumentationUrlProvider());
            Provider argsDest = project.getLayout().getBuildDirectory().file("tmp/" + t.getName() + "-args.txt");
            t.getOutputFile().set(argsDest);
        });
        final Provider linksOutput = generateLinks.flatMap(t -> t.getOutputFile());
        project.getTasks().matching(t -> t.getName().equals("javadoc") && t instanceof Javadoc).configureEach(t -> {
            t.getInputs().file((Object)linksOutput).withPropertyName("crossDocOfflineLinks");
            t.doFirst((Action)new Action<Task>(){

                public void execute(@NotNull Task arg0) {
                    ((Javadoc)arg0).getOptions().optionFiles(new File[]{((RegularFile)linksOutput.get()).getAsFile()});
                }
            });
        });
    }

    private void registerCopyTask(Project project, CrossdocExtension extension) {
        project.getTasks().register(COPY_JAVADOC_TASK_NAME, CopyJavadoc.class, t -> {
            t.getProjectName().set(project.provider(() -> project.getName()));
            t.getProjectPath().set(project.provider(() -> project.getPath()));
            t.getDocumentationUrlProvider().set(extension.projectDocumentationUrlProvider());
            t.getJavadocFiles().from(new Object[]{project.getTasks().named("javadoc")});
            t.getRootDir().set(project.getRootDir());
        });
    }

    private boolean hasJavadocTaskAndConfiguration(Project project) {
        return project.getTasks().getNames().contains("javadoc") && project.getConfigurations().getNames().contains("javadocElements");
    }
}

