/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.indra.crossdoc;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Objects;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;

interface BuildTreeComparer {
    public static final boolean HAS_GRADLE_9_1_0 = GradleVersion.current().getBaseVersion().compareTo(GradleVersion.version((String)"9.1.0")) >= 0;
    public static final boolean HAS_GRADLE_8_3 = GradleVersion.current().getBaseVersion().compareTo(GradleVersion.version((String)"8.3")) >= 0;

    @NotNull
    public static BuildTreeComparer comparer(@NotNull Project project) {
        if (HAS_GRADLE_9_1_0) {
            return new Gradle91Comparer(project);
        }
        if (HAS_GRADLE_8_3) {
            return new Gradle83Comparer(Objects.requireNonNull(project, "project"));
        }
        return Gradle82OrOlderComparer.INSTANCE;
    }

    public boolean isCurrentBuild(ProjectComponentIdentifier var1);

    public static final class Gradle91Comparer
    implements BuildTreeComparer {
        private final String projectBuildPath;

        Gradle91Comparer(Project project) {
            String buildPath = project.getGradle().getBuildPath();
            this.projectBuildPath = buildPath.isEmpty() ? ":" : buildPath;
        }

        @Override
        public boolean isCurrentBuild(ProjectComponentIdentifier identifier) {
            return this.projectBuildPath.equals(identifier.getBuild().getBuildPath());
        }
    }

    public static final class Gradle83Comparer
    implements BuildTreeComparer {
        private final String projectBuildPath;

        Gradle83Comparer(Project project) {
            String projectPath = project.getPath();
            String absoluteProjectPath = project.getBuildTreePath();
            String buildPath = absoluteProjectPath.substring(0, absoluteProjectPath.length() - projectPath.length());
            this.projectBuildPath = buildPath.isEmpty() ? ":" : buildPath;
        }

        @Override
        public boolean isCurrentBuild(ProjectComponentIdentifier identifier) {
            return this.projectBuildPath.equals(identifier.getBuild().getBuildPath());
        }
    }

    public static final class Gradle82OrOlderComparer
    implements BuildTreeComparer {
        static final Gradle82OrOlderComparer INSTANCE;
        static final MethodHandle IS_CURRENT_BUILD;

        private Gradle82OrOlderComparer() {
        }

        @Override
        public boolean isCurrentBuild(ProjectComponentIdentifier identifier) {
            try {
                return IS_CURRENT_BUILD.invoke(identifier.getBuild());
            }
            catch (Throwable ex) {
                throw new GradleException("Failed to invoke isCurrentBuild()", ex);
            }
        }

        static {
            MethodHandle currentBuild;
            INSTANCE = new Gradle82OrOlderComparer();
            try {
                currentBuild = MethodHandles.lookup().findVirtual(BuildIdentifier.class, "isCurrentBuild", MethodType.methodType(Boolean.TYPE));
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                currentBuild = null;
            }
            IS_CURRENT_BUILD = currentBuild;
        }
    }
}

