/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.indra.git;

import java.util.List;
import net.kyori.indra.git.RepositoryValueSource;
import org.eclipse.jgit.lib.ObjectId;
import org.gradle.api.Action;
import org.gradle.api.java.archives.Manifest;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ValueSourceSpec;
import org.jetbrains.annotations.NotNull;

public interface IndraGitExtension {
    public static final String MANIFEST_ATTRIBUTE_GIT_COMMIT = "Git-Commit";
    public static final String MANIFEST_ATTRIBUTE_GIT_BRANCH = "Git-Branch";

    public boolean isPresent();

    default public <V, P extends RepositoryValueSource.Parameters, S extends RepositoryValueSource<V, P>> Provider<V> repositoryValue(Class<S> valueSource) {
        return this.repositoryValue(valueSource, $ -> {});
    }

    public <V, P extends RepositoryValueSource.Parameters, S extends RepositoryValueSource<V, P>> Provider<V> repositoryValue(Class<S> var1, Action<? super ValueSourceSpec<P>> var2);

    @NotNull
    public Provider<String> describe();

    @NotNull
    public Provider<List<String>> tagNames();

    @NotNull
    public Provider<String> branchName();

    @NotNull
    public Provider<ObjectId> commit();

    default public void applyVcsInformationToManifest(Manifest manifest) {
        if (this.isPresent()) {
            Provider<ObjectId> commit = this.commit();
            Provider<String> branchName = this.branchName();
            if (commit.isPresent()) {
                manifest.getAttributes().put((Object)MANIFEST_ATTRIBUTE_GIT_COMMIT, (Object)((ObjectId)commit.get()).name());
            }
            if (branchName.isPresent()) {
                manifest.getAttributes().put((Object)MANIFEST_ATTRIBUTE_GIT_BRANCH, branchName.get());
            }
        }
    }
}

