/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.indra.git;

import java.io.IOException;
import net.kyori.indra.git.MappedRepositoryValueSource;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.Ref;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class QueryBranch<V>
extends MappedRepositoryValueSource.Parameterless<Ref, V> {
    private static final Logger LOGGER = Logging.getLogger(QueryBranch.class);

    @Override
    @Nullable
    protected Ref getRawValue(@NotNull Git repository) {
        try {
            @Nullable Ref ref = repository.getRepository().exactRef("HEAD");
            if (ref == null || !ref.isSymbolic()) {
                return null;
            }
            return ref.getTarget();
        }
        catch (IOException ex) {
            LOGGER.error("Failed to query current branch name from git:", (Throwable)ex);
            return null;
        }
    }

    public static abstract class Name
    extends QueryBranch<String> {
        @Override
        @NotNull
        protected String mapValue(@NotNull Git git, @NotNull Ref ref) {
            return ref.getName();
        }
    }
}

