/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.indra.git;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.kyori.indra.git.MappedRepositoryValueSource;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Ref;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;

public abstract class QueryTags<V>
extends MappedRepositoryValueSource.Parameterless<List<? extends Ref>, V> {
    private static final Logger LOGGER = Logging.getLogger(QueryTags.class);

    @Override
    @NotNull
    protected List<? extends Ref> getRawValue(@NotNull Git repository) {
        try {
            return repository.tagList().call();
        }
        catch (GitAPIException ex) {
            LOGGER.error("Failed to query git for a list of tags:", (Throwable)ex);
            return Collections.emptyList();
        }
    }

    public static abstract class Names
    extends QueryTags<List<String>> {
        @Override
        @NotNull
        protected List<String> mapValue(@NotNull Git git, @NotNull List<? extends Ref> value) {
            return value.stream().map(Ref::getName).collect(Collectors.toList());
        }
    }
}

