/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.indra.git;

import javax.inject.Inject;
import net.kyori.indra.git.internal.GitCache;
import org.eclipse.jgit.api.Git;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.ValueSource;
import org.gradle.api.provider.ValueSourceParameters;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RepositoryValueSource<V, P extends Parameters>
implements ValueSource<V, P> {
    @Inject
    public RepositoryValueSource() {
    }

    @Nullable
    public final V obtain() {
        Parameters params = (Parameters)this.getParameters();
        Git git = GitCache.getOrCreate(((Directory)params.getRootDir().get()).getAsFile()).git(((Directory)params.getProjectDir().get()).getAsFile(), (String)params.getDisplayName().get());
        if (git == null) {
            return null;
        }
        return this.obtain(git);
    }

    @Nullable
    protected abstract V obtain(@NotNull Git var1);

    public static interface Parameters
    extends ValueSourceParameters {
        @ApiStatus.Internal
        public DirectoryProperty getRootDir();

        @ApiStatus.Internal
        public DirectoryProperty getProjectDir();

        @ApiStatus.Internal
        public Property<String> getDisplayName();
    }

    public static abstract class Parameterless<V>
    extends RepositoryValueSource<V, Parameters> {
    }
}

