/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.indra.git.internal;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.kyori.indra.git.IndraGitExtension;
import net.kyori.indra.git.QueryBranch;
import net.kyori.indra.git.QueryTags;
import net.kyori.indra.git.RepositoryValueSource;
import net.kyori.indra.git.internal.GitCache;
import net.kyori.mammoth.Configurable;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.RefNotFoundException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;
import org.gradle.api.Action;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.provider.ValueSourceSpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class IndraGitExtensionImpl
implements IndraGitExtension {
    private static final Logger LOGGER = Logging.getLogger(IndraGitExtensionImpl.class);
    private final ProviderFactory providers;
    private final File rootDir;
    private final File projectDir;
    private final String displayName;

    @Inject
    public IndraGitExtensionImpl(ProviderFactory providers, File rootDir, File projectDir, String displayName) {
        this.rootDir = rootDir;
        this.providers = providers;
        this.projectDir = projectDir;
        this.displayName = displayName;
    }

    @Override
    public boolean isPresent() {
        return this.git() != null;
    }

    @VisibleForTesting
    @Nullable
    public Git git() {
        return GitCache.get(this.rootDir).git(this.projectDir, this.displayName);
    }

    @Override
    public <V, P extends RepositoryValueSource.Parameters, S extends RepositoryValueSource<V, P>> Provider<V> repositoryValue(Class<S> valueSource, Action<? super ValueSourceSpec<P>> configureAction) {
        return this.providers.of(valueSource, spec -> {
            RepositoryValueSource.Parameters params = (RepositoryValueSource.Parameters)spec.getParameters();
            params.getRootDir().set(this.rootDir);
            params.getProjectDir().set(this.projectDir);
            params.getDisplayName().set((Object)this.displayName);
            Configurable.configure((Object)spec, (Action)configureAction);
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static Ref headTag(Git git) {
        try {
            @Nullable Ref head = git.getRepository().findRef("HEAD");
            if (head == null) {
                return null;
            }
            ObjectId headCommit = head.getLeaf().getObjectId();
            try (RevWalk walk = new RevWalk(git.getRepository());){
                Ref tag;
                RevObject parsed;
                ObjectId commitId;
                Iterator iterator = git.tagList().call().iterator();
                do {
                    if (!iterator.hasNext()) return null;
                } while (!ObjectId.isEqual((AnyObjectId)(commitId = (parsed = walk.peel(walk.parseAny((AnyObjectId)(tag = (Ref)iterator.next()).getObjectId()))).toObjectId()), (AnyObjectId)headCommit));
                Ref ref = tag;
                return ref;
            }
        }
        catch (IOException | GitAPIException ex) {
            LOGGER.error("Failed to resolve current HEAD tag:", ex);
        }
        return null;
    }

    @Override
    @NotNull
    public Provider<String> describe() {
        return this.repositoryValue(QueryDescribe.class);
    }

    @Override
    @NotNull
    public Provider<List<String>> tagNames() {
        return this.repositoryValue(QueryTags.Names.class).map(list -> list.stream().map(Repository::shortenRefName).collect(Collectors.toList()));
    }

    @Override
    @NotNull
    public Provider<String> branchName() {
        return this.repositoryValue(QueryBranch.Name.class).map(Repository::shortenRefName);
    }

    @Override
    @NotNull
    public Provider<ObjectId> commit() {
        return this.repositoryValue(QueryCommit.class);
    }

    public static abstract class QueryDescribe
    extends RepositoryValueSource.Parameterless<String> {
        @Override
        @Nullable
        protected String obtain(@NotNull Git repository) {
            try {
                return repository.describe().setTags(true).setLong(true).call();
            }
            catch (RefNotFoundException ex) {
                return null;
            }
            catch (GitAPIException ex) {
                LOGGER.error("Failed to query git for a 'describe' result:", (Throwable)ex);
                return null;
            }
        }
    }

    public static abstract class QueryCommit
    extends RepositoryValueSource.Parameterless<ObjectId> {
        @Override
        @Nullable
        protected ObjectId obtain(@NotNull Git repository) {
            try {
                @Nullable Ref head = repository.getRepository().exactRef("HEAD");
                if (head == null) {
                    return null;
                }
                return head.getObjectId();
            }
            catch (IOException ex) {
                LOGGER.error("Failed to query git for the current HEAD commit:", (Throwable)ex);
                return null;
            }
        }
    }
}

