/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.indra.git.task;

import net.kyori.indra.git.task.RepositoryTask;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.Nullable;

public abstract class RequireClean
extends RepositoryTask {
    public RequireClean() {
        this.setGroup("verification");
    }

    @TaskAction
    public void check() {
        @Nullable Git git = this.repo();
        if (git == null) {
            return;
        }
        try {
            Status status = git.status().call();
            if (!status.isClean()) {
                StringBuilder message = new StringBuilder("Source root must be clean! Make sure your changes are committed. Changed files:");
                for (String changed : status.getUncommittedChanges()) {
                    message.append(System.lineSeparator()).append("- ").append(changed);
                }
                for (String untracked : status.getUntracked()) {
                    message.append(System.lineSeparator()).append("- ").append(untracked);
                }
                throw new GradleException(message.toString());
            }
        }
        catch (GitAPIException ex) {
            this.getLogger().error("Failed to query clean status of current project repository", (Throwable)ex);
        }
    }
}

