/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.indra.licenser.spotless;

import com.diffplug.gradle.spotless.FormatExtension;
import com.diffplug.gradle.spotless.GroovyExtension;
import com.diffplug.gradle.spotless.JavaExtension;
import com.diffplug.gradle.spotless.KotlinExtension;
import com.diffplug.gradle.spotless.SpotlessExtension;
import com.diffplug.spotless.generic.LicenseHeaderStep;
import java.util.Objects;
import net.kyori.indra.licenser.spotless.IndraSpotlessLicenserExtension;
import net.kyori.indra.licenser.spotless.internal.IndraSpotlessLicenserExtensionImpl;
import net.kyori.mammoth.ProjectPlugin;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.tasks.TaskContainer;
import org.jetbrains.annotations.NotNull;

public class IndraSpotlessLicenserPlugin
implements ProjectPlugin {
    private static final String JAVA_LICENSE_HEADER_DELIMITER = "(package |import |public |private |protected |sealed |class |enum |record |interface )";
    private static final String HEADER_FILE_NAME = "license_header.txt";
    private SpotlessExtension spotless;
    private IndraSpotlessLicenserExtensionImpl extension;

    public void apply(@NotNull Project project, @NotNull PluginContainer plugins, @NotNull ExtensionContainer extensions, @NotNull TaskContainer tasks) {
        IndraSpotlessLicenserExtensionImpl extension = (IndraSpotlessLicenserExtensionImpl)extensions.create(IndraSpotlessLicenserExtension.class, "indraSpotlessLicenser", IndraSpotlessLicenserExtensionImpl.class, new Object[]{project.getResources().getText()});
        extension.licenseHeaderFile().convention((Object)project.getResources().getText().fromFile((Object)project.getRootProject().file((Object)HEADER_FILE_NAME), "UTF-8"));
        plugins.apply("com.diffplug.spotless");
        this.spotless = (SpotlessExtension)extensions.getByType(SpotlessExtension.class);
        this.extension = extension;
        plugins.withId("java", $ -> this.applyToFormat("java", JavaExtension.class, JAVA_LICENSE_HEADER_DELIMITER));
        plugins.withId("org.jetbrains.kotlin.jvm", $ -> this.applyToFormat("kotlin", KotlinExtension.class, "(package |@file|import )"));
        plugins.withId("groovy", $ -> this.applyToFormat("groovy", GroovyExtension.class, JAVA_LICENSE_HEADER_DELIMITER));
    }

    private void applyToFormat(String name, Class<? extends FormatExtension> ext, String delimiter) {
        this.spotless.format(name, ext, format -> IndraSpotlessLicenserPlugin.addStep(format, this.extension, name, delimiter));
    }

    private static void addStep(FormatExtension format, IndraSpotlessLicenserExtensionImpl indraExtension, String name, String delimiter) {
        LicenseHeaderStep step = LicenseHeaderStep.headerDelimiter(indraExtension.createHeaderSupplier(name), (String)"");
        format.addStep(step.withYearMode(LicenseHeaderStep.YearMode.PRESERVE).build());
        FormatExtension formatExtension = format;
        Objects.requireNonNull(formatExtension);
        FormatExtension.LicenseHeaderConfig config = new FormatExtension.LicenseHeaderConfig(formatExtension, step);
        config.delimiter(delimiter);
        for (Action<FormatExtension.LicenseHeaderConfig> configStep : indraExtension.extraConfigSteps()) {
            configStep.execute((Object)config);
        }
    }
}

