/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.struct;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.zip.ZipFile;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.extern.IResultSaver;
import org.jetbrains.java.decompiler.struct.IDecompiledData;
import org.jetbrains.java.decompiler.struct.StructClass;
import org.jetbrains.java.decompiler.struct.lazy.LazyLoader;
import org.jetbrains.java.decompiler.util.DataInputFullStream;
import org.jetbrains.java.decompiler.util.InterpreterUtil;

public class ContextUnit {
    public static final int TYPE_FOLDER = 0;
    public static final int TYPE_JAR = 1;
    public static final int TYPE_ZIP = 2;
    private final int type;
    private final boolean own;
    private final String archivePath;
    private final String filename;
    private final IResultSaver resultSaver;
    private final IDecompiledData decompiledData;
    private final List<String> classEntries = new ArrayList<String>();
    private final List<String> dirEntries = new ArrayList<String>();
    private final List<String[]> otherEntries = new ArrayList<String[]>();
    private List<StructClass> classes = new ArrayList<StructClass>();
    private Manifest manifest;

    public ContextUnit(int type, String archivePath, String filename, boolean own, IResultSaver resultSaver, IDecompiledData decompiledData) {
        this.type = type;
        this.own = own;
        this.archivePath = archivePath;
        this.filename = filename;
        this.resultSaver = resultSaver;
        this.decompiledData = decompiledData;
    }

    public void addClass(StructClass cl, String entryName) {
        this.classes.add(cl);
        this.classEntries.add(entryName);
    }

    public void addDirEntry(String entry) {
        this.dirEntries.add(entry);
    }

    public void addOtherEntry(String fullPath, String entry) {
        if ("fernflower_abstract_parameter_names.txt".equals(entry)) {
            try {
                byte[] data;
                if (this.type == 1 || this.type == 2) {
                    try (ZipFile archive = new ZipFile(fullPath);){
                        data = InterpreterUtil.getBytes(archive, archive.getEntry(entry));
                    }
                } else {
                    data = InterpreterUtil.getBytes(new File(fullPath));
                }
                DecompilerContext.getStructContext().loadAbstractMetadata(new String(data, StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                String message = "Cannot read fernflower_abstract_parameter_names.txt from " + fullPath;
                DecompilerContext.getLogger().writeMessage(message, e);
            }
            return;
        }
        if (DecompilerContext.getOption("sef")) {
            return;
        }
        this.otherEntries.add(new String[]{fullPath, entry});
    }

    public void reload(LazyLoader loader) throws IOException {
        ArrayList<StructClass> lstClasses = new ArrayList<StructClass>();
        for (StructClass cl : this.classes) {
            StructClass newCl;
            String oldName = cl.qualifiedName;
            try (DataInputFullStream in = loader.getClassStream(oldName);){
                newCl = new StructClass(in, cl.isOwn(), loader);
            }
            lstClasses.add(newCl);
            LazyLoader.Link lnk = loader.getClassLink(oldName);
            loader.removeClassLink(oldName);
            loader.addClassLink(newCl.qualifiedName, lnk);
        }
        this.classes = lstClasses;
    }

    public void save() {
        switch (this.type) {
            case 0: {
                this.resultSaver.saveFolder(this.filename);
                for (String[] pair : this.otherEntries) {
                    this.resultSaver.copyFile(pair[0], this.filename, pair[1]);
                }
                for (int i2 = 0; i2 < this.classes.size(); ++i2) {
                    StructClass cl = this.classes.get(i2);
                    String entryName = this.decompiledData.getClassEntryName(cl, this.classEntries.get(i2));
                    if (entryName == null) continue;
                    String content = null;
                    if (this.decompiledData.processClass(cl)) {
                        content = this.decompiledData.getClassContent(cl);
                    }
                    if (content == null) continue;
                    int[] mapping = null;
                    if (DecompilerContext.getOption("bsm")) {
                        mapping = DecompilerContext.getBytecodeSourceMapper().getOriginalLinesMapping();
                    }
                    this.resultSaver.saveClassFile(this.filename, cl.qualifiedName, entryName, content, mapping);
                }
                break;
            }
            case 1: 
            case 2: {
                this.resultSaver.saveFolder(this.archivePath);
                this.resultSaver.createArchive(this.archivePath, this.filename, this.manifest);
                for (String dirEntry : this.dirEntries) {
                    this.resultSaver.saveDirEntry(this.archivePath, this.filename, dirEntry);
                }
                for (String[] pair : this.otherEntries) {
                    if (this.type == 1 && "META-INF/MANIFEST.MF".equalsIgnoreCase(pair[1])) continue;
                    this.resultSaver.copyEntry(pair[0], this.archivePath, this.filename, pair[1]);
                }
                int threads = DecompilerContext.getThreads();
                if (threads > 1) {
                    DecompilerContext rootContext = DecompilerContext.getCurrentContext();
                    ExecutorService executor = Executors.newFixedThreadPool(threads);
                    List toProcess = IntStream.range(0, this.classes.size()).parallel().mapToObj(i -> {
                        StructClass cl = this.classes.get(i);
                        return new ClassContext(cl, this.decompiledData.getClassEntryName(cl, this.classEntries.get(i)));
                    }).filter(e -> e.entryName != null).collect(Collectors.toList());
                    ArrayList futures = new ArrayList(toProcess.size());
                    for (ClassContext clCtx : toProcess) {
                        futures.add(executor.submit(() -> {
                            DecompilerContext.cloneContext(rootContext);
                            clCtx.ctx = DecompilerContext.getCurrentContext();
                            clCtx.shouldContinue = this.decompiledData.processClass(clCtx.cl);
                            DecompilerContext.setCurrentContext(null);
                        }));
                    }
                    executor.shutdown();
                    ContextUnit.waitForAll(futures);
                    futures.clear();
                    executor = Executors.newFixedThreadPool(threads);
                    for (ClassContext clCtx : toProcess) {
                        if (!clCtx.shouldContinue) continue;
                        futures.add(executor.submit(() -> {
                            DecompilerContext.setCurrentContext(clCtx.ctx);
                            String content = this.decompiledData.getClassContent(clCtx.cl);
                            this.resultSaver.saveClassEntry(this.archivePath, this.filename, clCtx.cl.qualifiedName, clCtx.entryName, content);
                            DecompilerContext.setCurrentContext(null);
                        }));
                    }
                    executor.shutdown();
                    ContextUnit.waitForAll(futures);
                } else {
                    for (int i3 = 0; i3 < this.classes.size(); ++i3) {
                        StructClass cl = this.classes.get(i3);
                        String entryName = this.decompiledData.getClassEntryName(cl, this.classEntries.get(i3));
                        if (entryName == null || !this.decompiledData.processClass(cl)) continue;
                        String content = this.decompiledData.getClassContent(cl);
                        this.resultSaver.saveClassEntry(this.archivePath, this.filename, cl.qualifiedName, entryName, content);
                    }
                }
                this.resultSaver.closeArchive(this.archivePath, this.filename);
            }
        }
    }

    private static void waitForAll(List<Future<?>> futures) {
        for (Future<?> future : futures) {
            try {
                future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void setManifest(Manifest manifest) {
        this.manifest = manifest;
    }

    public boolean isOwn() {
        return this.own;
    }

    public List<StructClass> getClasses() {
        return this.classes;
    }

    private static class ClassContext {
        public final StructClass cl;
        public final String entryName;
        public boolean shouldContinue;
        public DecompilerContext ctx;

        private ClassContext(StructClass cl, String entryName) {
            this.cl = cl;
            this.entryName = entryName;
        }
    }
}

