/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.moddevgradle.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import net.neoforged.moddevgradle.internal.NeoFormRuntimeTask;
import org.gradle.api.GradleException;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.OutputFiles;
import org.gradle.api.tasks.TaskAction;
import org.gradle.work.DisableCachingByDefault;

@DisableCachingByDefault(because="Implements its own caching")
abstract class CreateMinecraftArtifactsTask
extends NeoFormRuntimeTask {
    @Inject
    public CreateMinecraftArtifactsTask() {
        this.getOutputs().upToDateWhen(task -> (Boolean)((CreateMinecraftArtifactsTask)((Object)task)).getEnableCache().get());
        this.getEnableCache().convention((Object)false);
        this.getUseEclipseCompiler().convention((Object)false);
        this.getAnalyzeCacheMisses().convention((Object)false);
    }

    @InputFiles
    abstract ConfigurableFileCollection getAccessTransformers();

    @InputFiles
    abstract ConfigurableFileCollection getInterfaceInjectionData();

    @Input
    @Optional
    abstract Property<Boolean> getValidateAccessTransformers();

    @Input
    abstract Property<Boolean> getParchmentEnabled();

    @InputFiles
    abstract ConfigurableFileCollection getParchmentData();

    @Input
    abstract Property<String> getParchmentConflictResolutionPrefix();

    @OutputFile
    abstract RegularFileProperty getCompiledWithSourcesArtifact();

    @OutputFile
    abstract RegularFileProperty getCompiledArtifact();

    @OutputFile
    abstract RegularFileProperty getSourcesArtifact();

    @OutputFile
    abstract RegularFileProperty getResourcesArtifact();

    @OutputFiles
    abstract MapProperty<String, File> getAdditionalResults();

    @Input
    @Optional
    abstract Property<String> getNeoForgeArtifact();

    @Input
    @Optional
    abstract Property<String> getNeoFormArtifact();

    @Internal
    abstract Property<Boolean> getEnableCache();

    @Internal
    abstract Property<Boolean> getAnalyzeCacheMisses();

    @Input
    abstract Property<Boolean> getUseEclipseCompiler();

    @TaskAction
    public void createArtifacts() {
        ArrayList<String> args = new ArrayList<String>();
        args.add("run");
        for (File accessTransformer : this.getAccessTransformers().getFiles()) {
            args.add("--access-transformer");
            args.add(accessTransformer.getAbsolutePath());
        }
        for (File interfaceInjectionFile : this.getInterfaceInjectionData().getFiles()) {
            args.add("--interface-injection-data");
            args.add(interfaceInjectionFile.getAbsolutePath());
        }
        if (((Boolean)this.getValidateAccessTransformers().getOrElse((Object)false)).booleanValue()) {
            args.add("--validate-access-transformers");
        }
        if (((Boolean)this.getParchmentEnabled().get()).booleanValue()) {
            Set parchmentData = this.getParchmentData().getFiles();
            if (parchmentData.size() == 1) {
                args.add("--parchment-data");
                args.add(((File)parchmentData.iterator().next()).getAbsolutePath());
            } else if (parchmentData.size() > 1) {
                throw new GradleException("More than one parchment data file was specified: " + parchmentData);
            }
            String conflictResolutionPrefix = (String)this.getParchmentConflictResolutionPrefix().getOrElse((Object)"");
            if (this.getParchmentConflictResolutionPrefix().isPresent() && !conflictResolutionPrefix.isBlank()) {
                args.add("--parchment-conflict-prefix");
                args.add(conflictResolutionPrefix);
            }
        }
        if (!((Boolean)this.getEnableCache().get()).booleanValue()) {
            args.add("--disable-cache");
        }
        if (((Boolean)this.getAnalyzeCacheMisses().get()).booleanValue()) {
            args.add("--analyze-cache-misses");
        }
        if (((Boolean)this.getUseEclipseCompiler().get()).booleanValue()) {
            args.add("--use-eclipse-compiler");
        }
        if (this.getNeoForgeArtifact().isPresent()) {
            Collections.addAll(args, "--neoforge", (String)this.getNeoForgeArtifact().get());
        }
        if (this.getNeoFormArtifact().isPresent()) {
            Collections.addAll(args, "--neoform", (String)this.getNeoFormArtifact().get());
        }
        if (!this.getNeoFormArtifact().isPresent() && !this.getNeoForgeArtifact().isPresent()) {
            throw new GradleException("You need to specify at least 'version' or 'neoFormVersion' in the 'neoForge' block of your build script.");
        }
        Collections.addAll(args, "--dist", "joined", "--write-result", "clientResources:" + ((RegularFile)this.getResourcesArtifact().get()).getAsFile().getAbsolutePath());
        ((Map)this.getAdditionalResults().get()).forEach((name, file) -> Collections.addAll(args, "--write-result", name + ":" + file.getAbsolutePath()));
        if (this.getNeoForgeArtifact().isPresent()) {
            Collections.addAll(args, "--write-result", "compiledWithNeoForge:" + ((RegularFile)this.getCompiledArtifact().get()).getAsFile().getAbsolutePath(), "--write-result", "sourcesWithNeoForge:" + ((RegularFile)this.getSourcesArtifact().get()).getAsFile().getAbsolutePath(), "--write-result", "sourcesAndCompiledWithNeoForge:" + ((RegularFile)this.getCompiledWithSourcesArtifact().get()).getAsFile().getAbsolutePath());
        } else {
            Collections.addAll(args, "--write-result", "compiled:" + ((RegularFile)this.getCompiledArtifact().get()).getAsFile().getAbsolutePath(), "--write-result", "sources:" + ((RegularFile)this.getSourcesArtifact().get()).getAsFile().getAbsolutePath(), "--write-result", "sourcesAndCompiled:" + ((RegularFile)this.getCompiledWithSourcesArtifact().get()).getAsFile().getAbsolutePath());
        }
        this.run(args);
    }
}

