/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.moddevgradle.internal;

import java.util.ArrayList;
import java.util.Collections;
import javax.inject.Inject;
import net.neoforged.moddevgradle.internal.NeoFormRuntimeTask;
import org.gradle.api.GradleException;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

abstract class DownloadAssetsTask
extends NeoFormRuntimeTask {
    @Inject
    public DownloadAssetsTask() {
    }

    @Input
    @Optional
    abstract Property<String> getNeoForgeArtifact();

    @Input
    @Optional
    abstract Property<String> getNeoFormArtifact();

    @Input
    @Optional
    abstract Property<String> getMinecraftVersion();

    @OutputFile
    abstract RegularFileProperty getAssetPropertiesFile();

    @TaskAction
    public void createArtifacts() {
        ArrayList<String> args = new ArrayList<String>();
        Collections.addAll(args, "download-assets", "--write-properties", ((RegularFile)this.getAssetPropertiesFile().get()).getAsFile().getAbsolutePath());
        if (this.getMinecraftVersion().isPresent()) {
            Collections.addAll(args, "--minecraft-version", (String)this.getMinecraftVersion().get());
        } else if (this.getNeoFormArtifact().isPresent()) {
            Collections.addAll(args, "--neoform", (String)this.getNeoFormArtifact().get());
        } else if (this.getNeoForgeArtifact().isPresent()) {
            Collections.addAll(args, "--neoforge", (String)this.getNeoForgeArtifact().get());
        } else {
            throw new GradleException("One of minecraftVersion, neoFormArtifact or neoForgeArtifact must be specified to download assets.");
        }
        this.run(args);
    }
}

