/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.moddev.shadow.net.neoforged.vsclc.attribute;

import java.io.File;
import java.nio.file.Path;
import net.neoforged.moddev.shadow.net.neoforged.vsclc.attribute.PathWritable;

public interface PathLike
extends PathWritable {
    public static PathLike ofNio(Path path) {
        return new NioPath(path);
    }

    public static PathLike ofWorkSpaceFolder(Path relativePath) {
        return new NioPathWithPrefix("${workspaceFolder}" + File.separator, relativePath);
    }

    public static class NioPathWithPrefix
    extends NioPath {
        private final String prefix;

        private NioPathWithPrefix(String prefix, Path path) {
            super(path);
            this.prefix = prefix;
        }

        @Override
        public void write(StringBuilder sink, Path workspaceFolder) {
            sink.append(this.prefix);
            super.write(sink, workspaceFolder);
        }
    }

    public static class NioPath
    implements PathLike {
        private final Path path;

        private NioPath(Path path) {
            this.path = path;
        }

        @Override
        public void write(StringBuilder sink, Path workspaceFolder) {
            sink.append(PathWritable.pathToRelativeString(this.path, workspaceFolder));
        }
    }
}

