/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.moddevgradle.internal.utils;

import java.util.List;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.capabilities.Capability;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class DependencyUtils {
    private DependencyUtils() {
    }

    public static String guessMavenGav(ResolvedArtifactResult result) {
        Object artifactId;
        ComponentIdentifier componentIdentifier;
        String ext = "";
        String classifier = null;
        String filename = result.getFile().getName();
        int startOfExt = filename.lastIndexOf(46);
        if (startOfExt != -1) {
            ext = filename.substring(startOfExt + 1);
            filename = filename.substring(0, startOfExt);
        }
        if ((componentIdentifier = result.getId().getComponentIdentifier()) instanceof ModuleComponentIdentifier) {
            String version;
            ModuleComponentIdentifier moduleId = (ModuleComponentIdentifier)componentIdentifier;
            String artifact = moduleId.getModule();
            String expectedBasename = artifact + "-" + (version = moduleId.getVersion());
            if (filename.startsWith(expectedBasename + "-")) {
                classifier = filename.substring((expectedBasename + "-").length());
            }
            artifactId = moduleId.getGroup() + ":" + artifact + ":" + version;
        } else {
            List capabilities = result.getVariant().getCapabilities();
            if (capabilities.size() == 1) {
                String version;
                Capability capability = (Capability)capabilities.get(0);
                String artifact = capability.getName();
                String expectedBasename = artifact + "-" + (version = capability.getVersion());
                if (filename.startsWith(expectedBasename + "-")) {
                    classifier = filename.substring((expectedBasename + "-").length());
                }
                artifactId = capability.getGroup() + ":" + artifact + ":" + version;
            } else {
                artifactId = result.getId().getComponentIdentifier().toString();
            }
        }
        Object gav = artifactId;
        if (classifier != null) {
            gav = (String)gav + ":" + classifier;
        }
        if (!"jar".equals(ext)) {
            gav = (String)gav + "@" + ext;
        }
        return gav;
    }
}

