/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.moddevgradle.dsl;

import java.io.File;
import javax.inject.Inject;
import net.neoforged.moddevgradle.dsl.DataFileCollection;
import net.neoforged.moddevgradle.dsl.ModModel;
import net.neoforged.moddevgradle.dsl.Parchment;
import net.neoforged.moddevgradle.dsl.RunModel;
import net.neoforged.moddevgradle.dsl.VersionCapabilities;
import net.neoforged.moddevgradle.internal.Branding;
import net.neoforged.moddevgradle.internal.IdeIntegration;
import net.neoforged.moddevgradle.internal.ModDevArtifactsWorkflow;
import net.neoforged.moddevgradle.internal.ModdingDependencies;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;

public abstract class ModDevExtension {
    private final NamedDomainObjectContainer<ModModel> mods;
    private final NamedDomainObjectContainer<RunModel> runs;
    private final Parchment parchment;
    private final Project project;
    private final DataFileCollection accessTransformers;
    private final DataFileCollection interfaceInjectionData;

    @Inject
    public ModDevExtension(Project project, DataFileCollection accessTransformers, DataFileCollection interfaceInjectionData) {
        this.mods = project.container(ModModel.class);
        this.runs = project.container(RunModel.class, name -> (RunModel)project.getObjects().newInstance(RunModel.class, new Object[]{name, project, this.mods}));
        this.parchment = (Parchment)project.getObjects().newInstance(Parchment.class, new Object[0]);
        this.project = project;
        this.accessTransformers = accessTransformers;
        this.interfaceInjectionData = interfaceInjectionData;
        this.getValidateAccessTransformers().convention((Object)false);
        IdeIntegration ideIntegration = IdeIntegration.of(project, Branding.MDG);
        ideIntegration.runTaskOnProjectSync(this.getIdeSyncTasks());
    }

    public void accessTransformers(Action<DataFileCollection> action) {
        action.execute((Object)this.accessTransformers);
    }

    public DataFileCollection getAccessTransformers() {
        return this.accessTransformers;
    }

    public void setAccessTransformers(Object ... paths) {
        this.getAccessTransformers().getFiles().setFrom(paths);
    }

    public void interfaceInjectionData(Action<DataFileCollection> action) {
        action.execute((Object)this.interfaceInjectionData);
    }

    public DataFileCollection getInterfaceInjectionData() {
        return this.interfaceInjectionData;
    }

    public void setInterfaceInjectionData(Object ... paths) {
        this.getInterfaceInjectionData().getFiles().setFrom(paths);
    }

    public abstract Property<Boolean> getValidateAccessTransformers();

    public NamedDomainObjectContainer<ModModel> getMods() {
        return this.mods;
    }

    public void mods(Action<NamedDomainObjectContainer<ModModel>> action) {
        action.execute(this.mods);
    }

    public NamedDomainObjectContainer<RunModel> getRuns() {
        return this.runs;
    }

    public void runs(Action<NamedDomainObjectContainer<RunModel>> action) {
        action.execute(this.runs);
    }

    public Parchment getParchment() {
        return this.parchment;
    }

    public void parchment(Action<Parchment> action) {
        action.execute((Object)this.parchment);
    }

    public abstract ListProperty<TaskProvider<?>> getIdeSyncTasks();

    public void ideSyncTask(TaskProvider<?> task) {
        this.getIdeSyncTasks().add(task);
    }

    public void ideSyncTask(Task task) {
        this.getIdeSyncTasks().add((Object)task.getProject().getTasks().named(task.getName()));
    }

    public abstract MapProperty<String, File> getAdditionalMinecraftArtifacts();

    public void addModdingDependenciesTo(SourceSet sourceSet) {
        ModDevArtifactsWorkflow.get(this.project).addToSourceSet(sourceSet);
    }

    public String getVersion() {
        ModdingDependencies dependencies = ModDevArtifactsWorkflow.get(this.project).dependencies();
        if (dependencies.neoForgeDependency() == null) {
            throw new InvalidUserCodeException("You cannot retrieve the enabled version if you are in vanilla-only mode.");
        }
        return dependencies.neoForgeDependency().getVersion();
    }

    public String getMinecraftVersion() {
        return ModDevArtifactsWorkflow.get(this.project).versionCapabilities().minecraftVersion();
    }

    public VersionCapabilities getVersionCapabilities() {
        return ModDevArtifactsWorkflow.get(this.project).versionCapabilities();
    }
}

